% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prototype.R
\name{pdata}
\alias{pdata}
\title{Create Population Dynamics Data}
\usage{
pdata(x, init, t, lambda, formula)
}
\arguments{
\item{x}{an object of class "\code{eode}" describing the ODE system in focus.}

\item{init}{a data frame describing the initial conditions of the population.
Each column should correspond to a variable in the ODE system, hence the name of
column will be automatically checked to make sure it matches a variable in the ODE
system. Each row represents an independent observation}

\item{t}{a numerical vector that describes the time for each observation}

\item{lambda}{a data frame describing the observation values of population
dynamics. Each column is an variable and each row represents an independent
observation.}

\item{formula}{a character that specifies how the observed variable can be
predicted by the ODE system.}
}
\value{
an object of "\code{pdata}" class
}
\description{
Create a new data set to describe population dynamics with initial conditions.
The data is mainly used to train the ODE model described by an object of "\code{eode}"
class.
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
pdata(x,
  init = data.frame(x = c(10, 20), y = c(5, 15)),
  t = c(3, 3),
  lambda = data.frame(z = c(15, 30)),
  formula = "z = x + y"
)
}
