% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_performance.R
\name{coverage_beta}
\alias{coverage_beta}
\title{Empirical coverage of confidence intervals}
\usage{
coverage_beta(df, true_rr)
}
\arguments{
\item{df}{A data frame of replicated simulations which must include columns
titled \code{lower_ci} and \code{upper_ci}.}

\item{true_rr}{The true relative risk used to simulate the data.}
}
\value{
A data frame with the percent of confidence intervals for the
   estimated log relative risk over \code{n_reps} simulations which include
   the true log relative risk.
}
\description{
Calculates the percent of simulations in which the estimated 95\% confidence
interval for the log relative risk includes the true value of the log
relative risk.
}
\examples{
sims <- create_sims(n_reps = 10, n = 600, central = 100,
                    sd = 10, exposure_type = "continuous",
                    exposure_trend = "cos1", exposure_slope=1,
                    exposure_amp = 0.6,
                    average_outcome = 20,
                    outcome_trend = "no trend",
                    rr = 1.01)
fits <- fit_mods(data = sims, custom_model = spline_mod,
                 custom_model_args = list(df_year = 1))
coverage_beta(df=fits, true_rr = 1.02)

}
