% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance}
\alias{performance}
\title{Performance Analysis Calculation}
\usage{
performance(
  data = NULL,
  cands = "",
  candidate = "",
  preferred_candidate = "",
  total = "",
  contest = "",
  year = "",
  election_type = "",
  map = "",
  jurisdiction = "",
  includeTotal = FALSE
)
}
\arguments{
\item{data}{A data.frame object containing precinct-level election results 
for contests of interest. It must include candidate vote counts and contest 
total votes fields and must be subsetted to the relevant precincts. This 
data.frame will likely be the output of a "Split Precinct Analysis".}

\item{cands}{A character vector of the candidate vote counts field names 
from \code{data} that are relevant to the given year and contest being analyzed.}

\item{candidate}{A character vector of candidate names. The names must be listed 
in the same order \code{cands}. The values will appear in the output 
data.frame exactly as they are written in this argument.}

\item{preferred_candidate}{A character vector of preferred racial groups 
associated with the candidates. The values must be listed in the correct 
order with respect to the \code{cands}/\code{candidate} arguments. The values
will appear in the output data.frame exactly as they are written in this 
argument.}

\item{total}{A character vector of the the contest total vote count field names 
from \code{data}.}

\item{contest}{The name of the contest being analyzed}

\item{year}{The year of the contest being analyzed}

\item{election_type}{The election type the contest being analyzed (e.g 
"General" or "Primary")}

\item{map}{String containing the name of the district map being 
analyzed (e.g "remedial" or "adopted"). This is an optional field that 
defaults to blank.}

\item{jurisdiction}{String containing the name of the jurisdiction being 
analyzed (i.e a district number or "County"). Be sure that \code{data} is 
subsetted only to this jurisdiction.}

\item{includeTotal}{Boolean indicating if a total number of votes row should 
be appended to the output data.frame}
}
\value{
data.frame of Performance Analysis results by candidate
}
\description{
Performance Analysis calculates election outcomes of past 
contests given hypothetical voting district(s). This analysis has been used to 
determine if a Gingles III violation occurs due to how a district map is drawn.
It can also be used to demonstrate that a more equitable alternative map exists.
This function assumes RPV so it should only be used with contests where RPV 
has been established.
}
\examples{

library(eiExpand)
data(south_carolina)

# Get sample election data
D5_election <- south_carolina \%>\%
   dplyr::filter(District == 5)

# Run performance Analysis on 2018 Governor contest
perf_results <- performance(
  data = D5_election,
  cands = c("R_mcmaster", "D_smith"), 
  candidate = c("McMaster (R)", "Smith (D)"), # formatted candidate names
  preferred_candidate = c("White", "Black"), # race preference of candidates respectively
  total = "total_gov",
  contest = "Governor",
  year = 2018,	
  election_type = "General",	
  jurisdiction = "District 5"
) 
}
\author{
Rachel Carroll <rachelcarroll4@gmail.com>

Loren Collingwood <lcollingwood@unm.edu>
}
