% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiler-TransformRecipe.R
\name{TransformRecipe}
\alias{TransformRecipe}
\title{TransformRecipe S3 constructor}
\usage{
TransformRecipe(
  elementary_axes_lengths,
  axis_name2elementary_axis,
  input_composition_known_unknown,
  axes_permutation,
  first_reduced_axis,
  added_axes,
  output_composite_axes
)
}
\arguments{
\item{elementary_axes_lengths}{Integer vector. List of sizes for elementary
axes as they appear in the input (left) expression. This is what (after
computing unknown parts) will be a shape after first transposition. This does
not include any ellipsis dimensions.}

\item{axis_name2elementary_axis}{\code{\link[r2r:hashtable]{r2r::hashmap()}} Mapping from name to
position. if additional axes are provided, they should be set in prev array.
The keys are unclassed \code{\link[=AxisNames]{AxisNames()}} objects, and the values are
integer positions of the elementary axes.}

\item{input_composition_known_unknown}{List of list(known, unknown).
known and unknown are integer vectors containing axis positions. These
unknown and unknown integer vectors represent an unordered set and are
always sorted to help with testing.
ascending order for deterministic output.}

\item{axes_permutation}{Integer vector. Permutation applied to elementary
axes, if ellipsis is absent.}

\item{first_reduced_axis}{Integer of length 1. First position of reduced
axes. Permutation puts reduced axes in the end, we only need to know the
first position.}

\item{added_axes}{\code{\link[r2r:hashtable]{r2r::hashmap()}}. Axis position -> axis index. At which
positions which of elementary axes should appear.}

\item{output_composite_axes}{List of integer vectors. Ids of axes as they
appear in result. Again pointers to elementary_axes_lengths, only used to
infer result dimensions.}
}
\value{
An object of class 'TransformRecipe'.
}
\description{
Recipe describes actual computation pathway. Can be applied to a
tensor or variable.
}
\keyword{internal}
