% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_wrf.R
\name{to_wrf}
\alias{to_wrf}
\title{Combine total/spatial/temporal/split and write emission to file}
\usage{
to_wrf(
  POL,
  file = file.choose(),
  name = NA,
  total = NA,
  norm = FALSE,
  profile = 1,
  weights = 1,
  k = 1,
  verbose = TRUE
)
}
\arguments{
\item{POL}{matrix or array of emissions of spatial weights}

\item{file}{emission file name}

\item{name}{species to be write}

\item{total}{total of emited species (modifier)}

\item{norm}{if the spatial weights need to be normalized (modifier)}

\item{profile}{temporal profile to expand the emissions (modifier)}

\item{weights}{weight of each species (modifier)}

\item{k}{constant passed to wrf_put}

\item{verbose}{display additional information}
}
\description{
Function to expand, split and write emissions. The input is expanded into
time by profile and split between variables with diferent weights.
}
\note{
length(profile) must be the number of times in the emission
file (value of frames_per_auxinput5 if wrf_create() was used to
create this file).

total is an additional way to calculate or correct the total emissions

sum(profile) = 1 and sum(weights) = 1 to conserve mass

names and weights must have the same length
}
\examples{
\dontrun{
dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
           wrfchemi_dir = file.path(tempdir(), "EMISS"),
           frames_per_auxinput5 = 24)

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS"),
                    pattern = "wrfchemi",
                    full.names = TRUE)

data(Lights)

perfil <- c(0.010760058, 0.005280596, 0.002883553, 0.002666932,
            0.005781312, 0.018412838, 0.051900411, 0.077834636,
            0.067919758, 0.060831614, 0.055852868, 0.052468599,
            0.050938043, 0.051921718, 0.052756244, 0.052820165,
            0.058388406, 0.072855890, 0.075267137, 0.063246412,
            0.042713523, 0.029108975, 0.022091855, 0.015298458)

plot(perfil,
     ty = "l",
     col= "purple",
     xlab = "Hour",
     main = "Time profile",
     ylab = "Weight",
     axes = FALSE,
     xlim = c(0, 24))
axis(2)
axis(1,
     at = c(0, 6, 12, 18, 24),
     labels = c("00:00","06:00","12:00","18:00","00:00"))

to_wrf(Lights,
      files[1],
      total = 1521983,
      profile = perfil,
      name = "E_CO")
}
}
\seealso{
\link{wrf_create}, \code{\link{wrf_get}},\code{\link{wrf_profile}}  and \code{\link{wrf_plot}}
}
\author{
Daniel Schuch
}
