% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_raster.R
\name{wrf_raster}
\alias{wrf_raster}
\title{Creates raster from a variable from a wrf file}
\usage{
wrf_raster(
  file = file.choose(),
  name = NA,
  latlon = F,
  level = 1,
  as_polygons = FALSE,
  map,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{file}{wrf file}

\item{name}{variable name}

\item{latlon}{project the output in "+proj=longlat +datum=WGS84 +no_defs"}

\item{level}{only for 4d data, default is 1 (surface)}

\item{as_polygons}{logical, true to return a poligon instead of a raster}

\item{map}{(optional) file with lat-lon variables and grid information}

\item{verbose}{display additional information}

\item{...}{extra arguments passed to ncdf4::ncvar_get}
}
\description{
Return a Raster
}
\examples{
{

wrf <- paste(system.file("extdata", package = "eixport"),
                         "/wrfinput_d02", sep="")

r <- wrf_raster(file=wrf, name='XLAT')

library(raster)
plot(r, axes = TRUE)
}
}
