% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_functions.R
\name{aggregate_boot_ML}
\alias{aggregate_boot_ML}
\title{Aggregate bootstrapped ML estimates}
\usage{
aggregate_boot_ML(boot_ML_result = NULL)
}
\arguments{
\item{boot_ML_result}{a list returned by \code{bootML()}.}
}
\value{
a named list of long format data frames containing aggregated statistic estimates.
\item{boot_id}{index of bootstrap sample which resulted in value}
\item{col_id}{value identifier}
\item{row_id}{optional value identifier used when the result has more than 1 dimension}
\item{value}{statistic value}
}
\description{
\code{aggregate_boot_ML()} rearranges the bootstrap results from \code{boot_ML()} by
statistic instead of bootstrap iteration.
}
\examples{
# Set seed for this example
set.seed(11001101)

# Generate data for 4 binary methods
my_sim <- generate_multimethod_data(
  "binary",
  n_obs = 75,
  n_method = 4,
  se = c(0.87, 0.92, 0.79, 0.95),
  sp = c(0.85, 0.93, 0.94, 0.80),
  method_names = c("alpha", "beta", "gamma", "delta"))

# Bootstrap ML results
boot_ex <- boot_ML(
  "binary",
  data = my_sim$generated_data,
  n_boot = 20)

# Aggregate Bootstrap ML results by statistic
aggregate_boot_ML(boot_ex)

# Plot Bootstrap ML estimate distributions
plot(boot_ex)
}
