% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-svg.R
\name{as_svg}
\alias{as_svg}
\title{Wrap a single emphatic object into an SVG for display}
\usage{
as_svg(
  x,
  width = 1200,
  height = 900,
  ...,
  font_size = NULL,
  style = list(),
  browsable = FALSE
)
}
\arguments{
\item{x}{emphatic object}

\item{width, height}{viewBox dimensions for SVG}

\item{...}{other arguments passed to \code{as.character.emphatic()}}

\item{font_size}{CSS font-size. Default: NULL means to not adjust font size.
Otherwise, use valid CSS \code{font-size} specification e.g.
"3em", "22px" etc.}

\item{style}{html tag styling to apply to the \code{<pre>} wrapper for the
returned HTML}

\item{browsable}{Should the SVG be rendered to the RStudio Viewer pane when
when printed (instead of console output)? Default: FALSE}
}
\value{
Character string containing SVG representation
}
\description{
This is mainly useful within a github \code{README.md} since github will
not rendered html-styled text in colour, but \emph{will} render it correctly
if it is within a \code{<svg>} tags.
}
\details{
This is just a the results of \code{as_html()} wrapped in \code{<svg>} tags
}
\examples{
hl_diff('hello', 'there') |>
  as_svg() |>
  cat()
}
