% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envirem-package.R
\docType{package}
\name{envirem}
\alias{envirem-package}
\alias{envirem}
\title{envirem}
\description{
Generation of bioclimatic rasters that are complementary to the typical 19 bioclim variables.
}
\details{
Package: envirem\cr
Type: Package\cr
Version: 2.2\cr
Date: 2020-06-03\cr
License: GPL-2 | GPL-3\cr

\strong{NOTE}: Temperature rasters are now assumed by default to be in degrees C and precipitation in mm. 
rasters in degrees C * 10. Worldclim v2 uses degrees C. CHELSA has several options, depending 
on whether rasters are downloaded as floating point or integer. Therefore, there is an argument 
\code{tempScale} to specify the units of temperature, and \code{precipScale} to define precipitation units:

For example:\cr
If using worldclim v1 data where temperature is in degrees C * 10, specify 
\code{tempScale = 10}.\cr
If using worldclim v2 where temperature is in degrees C, specify \code{tempScale = 1}.\cr
For CHELSA, read the documentation and carefully examine the rasters. 

If a function does not have the \code{tempScale} argument, then the function is not sensitive
to the units of the input temperature rasters.


Of course, it is also perfectly acceptable to leave \code{tempScale = 1} and \code{precipScale = 1} 
and modify the input rasters yourself. 


The main function for generating ENVIREM rasters is \code{\link{generateEnvirem}}. 
A complete tutorial of this R package can be found at \url{https://ptitle.github.io/envirem/}.
}
\references{
\url{https://github.com/ptitle/envirem}

Title, P.O., Bemmels, J.B. 2018. ENVIREM: An expanded set of bioclimatic and topographic variables increases flexibility and improves performance of ecological niche modeling. Ecography 41:291–307.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ptitle/envirem}
  \item Report bugs at \url{https://github.com/ptitle/envirem/issues}
}

}
\author{
Pascal O. Title, Jordan B. Bemmels
}
\keyword{package}
