% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{plot.KRDetect}
\alias{plot.KRDetect}
\title{Outlier detection plot}
\usage{
\method{plot}{KRDetect}(x, show.segments = TRUE, plot.type = "all",
  xlab = "index", ylab = "data values", ...)
}
\arguments{
\item{x}{a KRDetect object obtained as an output of function \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} or \code{\link{KRDetect.outliers.EV}} for identification of outliers.}

\item{show.segments}{a logical variable specifying if vertical lines representing individual segments are plotted. Only required for results obtained using \code{\link{KRDetect.outliers.changepoint}} function.}

\item{plot.type}{a type of plot with outliers displayed.

Possible options for \code{\link{KRDetect.outliers.controlchart}} are
\itemize{
  \item{\code{"all"}} {to show outliers detected using control chart \emph{x}, \emph{R} and \emph{s}}
  \item{\code{"x"}} {to show outliers detected using control chart \emph{x}}
  \item{\code{"R"}} {to show outliers detected using control chart \emph{R}}
  \item{\code{"s"}} {to show outliers detected using control chart \emph{s}}
}

Possible options for \code{\link{KRDetect.outliers.EV}} are
\itemize{
  \item{\code{"all"}} {to show outliers with both extremely low and high value}
  \item{\code{"min"}} {to show outliers with extremely low value}
  \item{\code{"max"}} {to show outliers with extremely high value}
}}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{...}{further arguments to be passed to the \code{\link{plot}} function.}
}
\description{
Plot of results obtained using functions \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} and \code{\link{KRDetect.outliers.EV}} for identification of outliers.
The function graphically visualizes results obtained using functions for outlier detection implemented in package \pkg{envoutliers}.
}
\details{
This function plots the results obtained using function \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} or \code{\link{KRDetect.outliers.EV}} implemented in package \pkg{envoutliers} and identificating outliers.
}
\examples{
data("mydata", package = "openair")
x = mydata$o3[format(mydata$date, "\%m \%Y") == "12 2002"]
result = KRDetect.outliers.EV(x)
plot(result)
}
