% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMDClasses.R
\docType{class}
\name{EX1-class}
\alias{EX1-class}
\alias{header,EX1-method}
\alias{ex1,EX1-method}
\alias{content,EX1-method}
\alias{region,EX1-method}
\alias{protocol,EX1-method}
\alias{Exposure1}
\alias{length,EX1-method}
\alias{show,EX1-method}
\alias{selectYears,EX1-method}
\alias{readEX1x1}
\title{EX1 class for HMD eposure files 1x1}
\usage{
\S4method{header}{EX1}(object)

\S4method{ex1}{EX1}(object)

\S4method{content}{EX1}(object)

\S4method{region}{EX1}(object)

\S4method{protocol}{EX1}(object)

Exposure1(header, ex1, content, region, protocol)

\S4method{length}{EX1}(x)

\S4method{show}{EX1}(object)

\S4method{selectYears}{EX1}(object, selectYears)

readEX1x1(infile)
}
\arguments{
\item{object}{EX1-object}

\item{header}{vector}

\item{ex1}{data.table}

\item{content}{character}

\item{region}{character}

\item{protocol}{character}

\item{x}{EX1-object}

\item{selectYears}{vector}

\item{infile}{character file name}
}
\value{
The \code{header}-method returns the raw header information

The \code{ex1}-method returns the exposure table

The \code{content}-method returns the content information

The \code{region}-method returns the regional information

The \code{protocol}-method returns the protocol information

The \code{Exposure1}-constructor returns an EX1 object

The \code{length}-method returns the number of rows

The \code{selectYears}-method returns an EX1 object

The \code{readEX1x1}-method returns an EX1 object
}
\description{
The class \code{EX1} stores HMD exposure information in a systematic way.

The \code{header}-method gets the raw header information of an EX1 object

The \code{ex1}-method gets the exposure information of an EX1 object

The \code{content}-method gets the exposure table information of an EX1 object

The \code{region}-method gets the regional information of an EX1 object

The \code{protocol}-method gets the protocol information of an EX1 object

The \code{Exposure1}-constructor creates an EX1 object

The \code{length}-method gets the number of rows int the EX1 ex1 data.table

The \code{selectYears}-method gets a subset of an EX1 object

The \code{readEX1x1}-method reads all information from the file 1x1 exposure table
}
\details{
This \code{EX1} class fits to Human Mortality Database (HMD) 1x1 period exposure tables.
See https://www.mortality.org/ for data details.
An EX1 instance stores the raw header, the content, 
the version protocol and regional information and the
exposure table as a data.table object.
The validation adds a pure numeric age AgeLow to the exposure table.
Try demo(EX1) for a demonstration.
}
\section{Slots}{

\describe{
\item{\code{content}}{describes the content}

\item{\code{region}}{regional entity}

\item{\code{header}}{includes the raw header information}

\item{\code{ex1}}{stores the exposure table (data.table)}

\item{\code{protocol}}{contains the protocol information}
}}

\examples{
e1 <- readEX1x1(file.path(system.file(package="eoR"), "extdata", "DEUTNP.Exposures_1x1m.txt"))
header(e1)
ex1(e1)[, table(Year)]
}
