% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_likelihoods.R
\name{.offspring_ll}
\alias{.offspring_ll}
\title{Log-likelihood of the summary (size/length) of chains with generic offspring
distribution}
\usage{
.offspring_ll(x, offspring_dist, statistic, nsim_offspring = 100, ...)
}
\arguments{
\item{x}{A numeric vector of chain summaries (sizes/lengths).}

\item{offspring_dist}{Offspring distribution: a \verb{<function>} like the ones
provided by R to generate random numbers from given distributions (e.g.,
\code{\link{rpois}} for Poisson). More specifically, the function needs to
accept at least one argument, \code{n}, which is the number of random
numbers to generate. It can accept further arguments, which will be passed
on to the random number generating functions. Examples that can be provided
here are \code{rpois} for Poisson distributed offspring, \code{rnbinom} for negative
binomial offspring, or custom functions.}

\item{statistic}{The chain statistic to track as the
stopping criteria for each chain being simulated when \code{stat_threshold} is not
\code{Inf}; A \verb{<string>}. It can be one of:
\itemize{
\item "size": the total number of cases produced by a chain before it goes
extinct.
\item "length": the total number of generations reached by a chain before
it goes extinct.
}}

\item{nsim_offspring}{Number of simulations of the offspring distribution
for approximating the distribution of the chain statistic summary
(size/length)}

\item{...}{any parameters to pass to \code{\link{simulate_chain_stats}}}
}
\value{
A numeric vector of log-likelihood values.
}
\description{
The log-likelihoods are calculated with a crude approximation using simulated
chain summaries by linearly approximating any missing values in the empirical
cumulative distribution function (ecdf).
}
\author{
Sebastian Funk James M. Azam
}
\keyword{internal}
