% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pvt_sensors}
\alias{pvt_sensors}
\title{Influenza and dengue digital surveillance sensors}
\usage{
pvt_sensors(
  auth,
  names,
  locations,
  epiweeks = "*",
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{auth}{string. Restricted access key (not the same as API key).}

\item{names}{character. Sensor names to fetch.}

\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch. Defaults to all ("*") dates.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/sensors.html}

This is the documentation of the API for accessing the Digital Surveillance
Sensors endpoint of the Delphi’s epidemiological. Note: this
repository was built to support modeling and forecasting efforts
surrounding seasonal influenza (and dengue). In the current COVID-19
pandemic, syndromic surveillance data, like ILI data (influenza-like
illness) through FluView, will likely prove very useful. However, we urge
caution to users examining the digital surveillance sensors, like ILI
Nearby, Google Flu Trends, etc., during the COVID-19 pandemic, because
these were designed to track ILI as driven by seasonal influenza, and were
NOT designed to track ILI during the COVID-19 pandemic.
}
\examples{
\dontrun{
pvt_sensors(
  auth = Sys.getenv("SECRET_API_AUTH_SENSORS"),
  names = "sar3",
  locations = "nat",
  epiweeks = epirange(201501, 202001)
)
}
}
\keyword{endpoint}
