% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{meta_rels_list_rel}
\alias{meta_rels_list_rel}
\title{List relationships under a meta relationship}
\usage{
meta_rels_list_rel(meta_rel, limit = 10, offset = 0, mode = c("table", "raw"))
}
\arguments{
\item{meta_rel}{Name of a meta relationship (e.g. MR). Use \code{meta_rels_list} to get the full list of meta relationships.}

\item{limit}{Max number of items to retrieve.}

\item{offset}{Number of items to skip. Use \code{limit} and \code{offset} in combination to do pagination.}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \code{GET /meta/rels/{meta_rel}/list}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-metarelsmeta_rellist}{\code{GET /meta/rels/{meta_rel}/list}}
}
\examples{
# List the first 5 MR relationships
\dontrun{
meta_rels_list_rel(meta_rel = "MR_EVE_MR", limit = 5)
}
}
