% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_devlin.R
\name{figure_1_4_1}
\alias{figure_1_4_1}
\title{Figure 1.4.1: Generate a Health State Density Curve (HSDC) for EQ-5D Data}
\usage{
figure_1_4_1(df, names_eq5d, eq5d_version)
}
\arguments{
\item{df}{Data frame with the EQ-5D columns}

\item{names_eq5d}{Character vector of column names for the EQ-5D dimensions}

\item{eq5d_version}{Version of the EQ-5D instrument}
}
\value{
A list containing:
  \item{plot_data}{A data frame with the cumulative distribution of profiles}
  \item{p}{A ggplot2 object showing the Health State Density Index}
}
\description{
This function calculates and plots the Health State Density Curve (HSDC) for a given
EQ-5D dataset. It concatenates dimension values to form health state profiles, filters
out invalid states based on the specified EQ-5D version, then computes the cumulative
distribution of profiles (profiles vs. observations). A diagonal reference line
indicates a perfectly even distribution. The function also calculates the Health State
Density Index (HSDI), representing how sharply the observed distribution deviates from
the diagonal.
}
\examples{
figure <- figure_1_4_1(
            df = example_data, 
            names_eq5d = c("mo", "sc", "ua", "pd", "ad"), 
            eq5d_version = "3L"
          )
figure$plot_data
figure$p
}
