#  File tests/testthat/test-coef_recovery.R in package ergm.ego, part of the
#  Statnet suite of packages for network analysis, https://statnet.org .
#
#  This software is distributed under the GPL-3 license.  It is free, open
#  source, and has the attribution requirements (GPL Section 7) at
#  https://statnet.org/attribution .
#
#  Copyright 2015-2025 Statnet Commons
################################################################################
test_that("complete ERGM and ergm.ego() give similar coef estimates",{
  data(faux.mesa.high)
  fmh.ego <- egor::as.egor(faux.mesa.high)

  ## Generated by:
  
  ## fit <- ergm(
  ##   faux.mesa.high ~ edges + degree(0:3) + nodefactor("Race") + nodematch("Race") + 
  ##     nodefactor("Sex") + nodematch("Sex") + absdiff("Grade") + gwesp(0,fix=TRUE),
  ##   control = snctrl(MCMLE.termination="Hummel"),
  ##   eval.loglik=FALSE
  ## )
  ## cat(deparse1(coef(fit)))

  ergm.coef <- c(edges = -3.01212110210054, degree0 = -0.249689850709604, degree1 = 0.0391692834163937, degree2 = -0.223287965436155, degree3 = 0.129052720153603, nodefactor.Race.Hisp = -1.15171844438798, nodefactor.Race.NatAm = -0.880840462703632, nodefactor.Race.Other = -2.24387136306054, nodefactor.Race.White = -0.612683978058459, nodematch.Race = 0.714746824167899, nodefactor.Sex.M = -0.153284589341771, nodematch.Sex = 0.5477943742698, absdiff.Grade = -1.08471237982666, gwesp.fixed.0 = 1.603202809316)
  
  egofit <- ergm.ego(
    fmh.ego ~ edges + degree(0:3) + nodefactor("Race") + nodematch("Race") + 
      nodefactor("Sex") + nodematch("Sex") + absdiff("Grade") + gwesp(0,fix=TRUE),
    popsize = network.size(faux.mesa.high),
    control = snctrl(MCMLE.termination="Hummel")
  )

  expect_equal(ignore_attr=TRUE,
               coef(egofit),
               c(0, ergm.coef),
               tolerance = 0.05
               )
})
