% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofN.R
\name{control.gofN.ergm}
\alias{control.gofN.ergm}
\alias{control.gofN}
\title{Auxiliary for Controlling Multinetwork ERGM Linear Goodness-of-Fit Evaluation}
\usage{
control.gofN.ergm(
  nsim = 100,
  obs.twostage = nsim/2,
  array.max = 128,
  simulate = control.simulate.ergm(),
  obs.simulate = control.simulate.ergm(),
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE
)

control.gofN(
  nsim = 100,
  obs.twostage = nsim/2,
  array.max = 128,
  simulate = control.simulate.ergm(),
  obs.simulate = control.simulate.ergm(),
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE
)
}
\arguments{
\item{nsim}{Number of networks to be randomly drawn using Markov chain Monte
Carlo.  This sample of networks provides the basis for comparing the model
to the observed network.}

\item{obs.twostage}{Either \code{FALSE} or an integer. This parameter
only has an effect if the network has missing data or
observational process. For such networks, evaluating the Pearson
residual requires simulating the expected value of the
conditional variance under the observation process. If \code{FALSE},
the simulation is performed conditional on the observed
network. However, a more accurate estimate can be obtained via a
two-stage process: \enumerate{

\item Sample networks from the model without the observational
constraint.

\item Conditional on each of those networks, sample with the
observational constraint, estimating the variance within each
sample and then averaging over the first-stage sample.

}

Then, \code{obs.twostage} specifies the number of unconstrained networks
to simulate from, which should divide the \code{\link[=control.gofN.ergm]{control.gofN.ergm()}}'s
\code{nsim} argument evenly.}

\item{array.max}{Try to avoid creating arrays larger in size (in
megabytes) than this. Is ignored if \code{save_stats} is passed.}

\item{simulate, obs.simulate}{Control lists produced by
\code{\link[ergm:control.simulate.ergm]{control.simulate.ergm()}} or equivalent for unconstrained and
constrained simulation, respectively. Parameters are inherited
from the model fit and can be overridden here.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See \code{\link[ergm:ergm-parallel]{ergm-parallel}}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Defaults
to using the \pkg{parallel} package with PSOCK clusters. See
\code{\link[ergm:ergm-parallel]{ergm-parallel}}.}

\item{parallel.version.check}{Logical: If TRUE, check that the
version of \CRANpkg{ergm} running on the slave
nodes is the same as that running on the master node.}

\item{parallel.inherit.MT}{Logical: If TRUE, slave nodes and
processes inherit the \code{\link[ergm:ergm-parallel]{set.MT_terms()}} setting.}
}
\description{
\code{control.gofN.ergm} (or its alias, \code{control.gofN}) is
intended to be used with \code{\link[=gofN]{gofN()}} specifically and will "inherit"
as many control parameters from \code{\link[ergm:ergm]{ergm}} fit as possible().
}
\details{
Auxiliary function as user interface for fine-tuning ERGM Goodness-of-Fit
Evaluation.
}
