% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-n.R
\name{check_n}
\alias{check_n}
\alias{is_n}
\title{Check If Argument Is Single Natural Number}
\usage{
check_n(
  x,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  zero = FALSE,
  ...
)

is_n(x, zero = FALSE)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{zero}{Optional. \code{TRUE} or \code{FALSE} which indicates if zero is
acceptable. The default value is \code{FALSE}.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
\code{check_n()} returns an invisible \code{NULL} if the argument
is valid, or it generates an error message.

\code{is_n()} returns \code{TRUE} or \code{FALSE}.
}
\description{
Check if an argument is a single natural number,
and if not, generate an error message.

Can be used to check indices, for example.
}
\examples{
x <- 1
check_n(x)

x <- 1L
check_n(x)

sapply(c(1, 2.1, 0, Inf, NA, -9), is_n)

\dontrun{
# `x` must be a numeric
x <- "1"
check_n(x)

# `x` must have length 1
x <- 1:2
check_n(x)

# `x` must not be `NA`
x <- NA_integer_
check_n(x)

# `x` must be larger than 0
x <- -1
check_n(x)

# `x` must be an integer in a mathematical sense
x <- 1.1
check_n(x)

# make `0` acceptable
x <- 0
check_n(x)
check_n(x, zero = TRUE)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
