% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boin_comb_selector.R
\name{get_boin_comb}
\alias{get_boin_comb}
\title{Get an object to fit the BOIN COMB model using the BOIN package.}
\usage{
get_boin_comb(
  parent_selector_factory = NULL,
  num_doses,
  target,
  use_stopping_rule = TRUE,
  ...
)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave as NULL to just use CRM from the start.}

\item{num_doses}{integer vector of the number of doses of treatment 1, 2}

\item{target}{We seek a dose with this probability of toxicity.}

\item{use_stopping_rule}{TODO}

\item{...}{Extra args are passed to \code{\link[BOIN]{next.comb}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
BOIN COMB model to outcomes.
}
\description{
Get an object to fit the BOIN COMB model using the BOIN package.
}
\examples{
num_doses <- c(3, 4)
target <- 0.25
boin_fitter <- get_boin_comb(num_doses = num_doses, target = target)
x1 <- fit(boin_fitter, outcomes = "1.1NNN")
x1
x2 <- fit(boin_fitter, outcomes = "1.1NNN 2.1TNT")
x2

}
\references{
Lin, R., & Yin, G. (2017).
Bayesian optimal interval design for dose finding in drug-combination trials.
Statistical methods in medical research, 26(5), 2155-2167.
}
