% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_any.R
\name{meta_any}
\alias{meta_any}
\title{Estimate any meta effect.}
\usage{
meta_any(
  data,
  yi,
  vi,
  labels = NULL,
  moderator = NULL,
  contrast = NULL,
  effect_label = "My effect",
  effect_size_name = "Effect size",
  moderator_variable_name = "My moderator",
  random_effects = TRUE,
  conf_level = 0.95
)
}
\arguments{
\item{data}{A data frame or tibble with columns}

\item{yi}{Name a column in data containing the effect size for each study}

\item{vi}{Name of a column in data containing the expected sampling variance
for each study}

\item{labels}{Name of a column in data containing a label for each study}

\item{moderator}{Optional name of a column in data containing a factor as a
categorical moderator}

\item{contrast}{Optional vector specifying a contrast analysis for the
categorical moderator.  Only define if a moderator is defined; vector
length should match number of levels in the moderator}

\item{effect_label}{Optional human-friendly name for the effect being
synthesized; defaults to 'My effect'}

\item{effect_size_name}{Optional human-friendly name of the effect size being
synthesized; defaults to 'Effect size'}

\item{moderator_variable_name}{Optional human-friendly name of the moderator,
if defined; If not passed but a moderator is defined, will be set to the
quoted name of the moderator column or 'My moderator'}

\item{random_effects}{Use TRUE to obtain a random effect meta-analysis
(usually recommended); FALSE for fixed effect.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}
}
\value{
An esci-estimate object; a list of data frames and properties.
Returned tables include:
\itemize{
\item \strong{es_meta} - A data frame of meta-analytic effect sizes.  If a moderator was
defined, there is an additional row for each level of the moderator.
\itemize{
\item \emph{effect_label} -  Study label
\item \emph{effect_size} - Effect size
\item \emph{LL} - Lower bound of conf_level\% confidence interval
\item \emph{UL} - Upper bound of conf_level\% confidence interval
\item \emph{SE} - Expected standard error
\item \emph{k} - Number of studies
\item \emph{diamond_ratio} - ratio of random to fixed effects meta-analytic effect sizes
\item \emph{diamond_ratio_LL} - lower bound of conf_level\% confidence interval for diamond ratio
\item \emph{diamond_ratio_UL} - upper bound of conf_level\% confidence interval for diamond ratio
\item \emph{I2} -  I2 measure of heterogeneity
\item \emph{I2_LL} - Lower bound of conf_level\% confidence interval for I2
\item \emph{I2_UL} - upper bound of conf_level\% confidence interval for I2
\item \emph{PI_LL} - lower bound of conf_level\% of prediction interval
\item \emph{PI_UL} - upper bound of conf_level\% of prediction interval
\item \emph{p} - p value for the meta-analytic effect size, based on null of exactly 0
\item *width - width of the effect-size confidence interval
\item \emph{FE_effect_size} - effect size of the fixed-effects model (regardless of if fixed effects was selected
\item \emph{RE_effect_size} - effect size of the random-effects model (regardless of if random effects was selected
\item \emph{FE_CI_width} - width of the fixed-effects confidence interval, used to calculate diamond ratio
\item \emph{RE_CI_width} - width of the fixed-effects confidence interval, used to calculate diamond ratio
}
\item \strong{es_heterogeneity} - A data frame of of heterogeneity values and
conf_level\% CIs for the meta-analytic effect size.  If a moderator was defined
also reports heterogeneity estimates for each level of the moderator.
\itemize{
\item \emph{effect_label} - study label
\item \emph{moderator_variable_name} - if moderator passed, gives name of the moderator
\item \emph{moderator_level} - 'Overall' and each level of moderator, if passed
\item \emph{measure} - Name of the measure of heterogeneity
\item \emph{estimate} - Value of the heterogeneity estimate
\item \emph{LL} - lower bound of conf_level\% confidence interval
\item \emph{UL} - upper bound of conf_level\% confidence interval
}
\item \strong{raw_data} - A data from with one row for each study that was passed
\itemize{
\item \emph{label} - study label
\item \emph{effect_size} - effect size
\item \emph{weight} - study weight in the meta analysis
\item \emph{sample_variance} - expected level of sampling variation
\item \emph{SE} - expected standard error
\item \emph{LL} - lower bound of conf_level\% confidence interval
\item \emph{UL} - upper bound of conf_level\% confidence interval
\item \emph{mean} - used to calculate study p value; this is the d value entered for the study
\item \emph{sd} - use to calculate study p value; set to 1 for each study
\item \emph{n} - study sample size
\item \emph{p} - p value for the study, based on null of exactly 0
}
}
}
\description{
\code{meta_any} is suitable for synthesizing any effect size across
multiple studies.  You must provide the effect size for each study and the
predicted sampling variance for each study.
}
\details{
#' Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_meta]{plot_meta()}}.

The meta-analytic effect size, confidence interval and heterogeneity
estimates all come from \code{\link[metafor:rma.uni]{metafor::rma()}}.

The diamond ratio and its confidence interval come from
\code{\link[=CI_diamond_ratio]{CI_diamond_ratio()}}.
}
\examples{
#' # Data set -- see Introduction to the New Statistics, 2nd edition
data("data_mccabemichael_brain")

# Fixed effect, 95\% CI
esizes <- esci::meta_mean(
  data = esci::data_mccabemichael_brain,
  means = "M Brain",
  sds = "s Brain",
  ns = "n Brain",
  labels = "Study name",
  random_effects = FALSE
)$raw_data

estimate <- esci::meta_any(
  data = esizes,
  yi = effect_size,
  vi = sample_variance,
  labels = label,
  effect_size_name = "Mean",
  random_effects = FALSE
)

myplot_forest <- esci::plot_meta(estimate)



}
