% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncc_stretch.R
\name{ncc_stretch}
\alias{ncc_stretch}
\title{Estimate relativ wave velocity change (dv/v) by correlation stretching}
\usage{
ncc_stretch(
  data,
  lag,
  master = "mean",
  normalise = TRUE,
  sides = "both",
  range = 0.01,
  steps = 100,
  method = "r",
  reject = 0,
  ...
)
}
\arguments{
\item{data}{\code{eseis} object of type \code{correlation}, output 
of \code{aux_correlate}.}

\item{lag}{\code{Numeric} vector of length two, range of the time lage
to analyse. If omitted, the time lag of the input data 
(\code{x$CC$lag}) is used.}

\item{master}{\code{Character} vector or value, either a user defined 
master correlation function or a keyword denoting the  method used to 
calculate master the correlation function. One out of \code{"mean"}, 
\code{"median"} and \code{"quantile"}. Default is \code{"mean"}. if 
\code{"quantile"} is used, the quantile probability must be specified as 
well, e.g., \code{"probs = 0.5"}.}

\item{normalise}{\code{Logical} value, option to normalise the data set 
before calculating the master trace. Default is \code{TRUE}.}

\item{sides}{\code{Character} value. One out of \code{"both"} (both sides
of the input data), \code{"left"} (only negative time lags), \code{"right"} 
(only positive time lags) and \code{single} (only right side is used,  
expecting data from a single source and direction). Default is 
\code{"both"}.}

\item{range}{\code{Numeric} value, relative range of the stretch. Default is 
\code{0.01} (1 percent).}

\item{steps}{\code{Numeric} value, number of stretch steps (step 
resolution). Default is \code{100}.}

\item{method}{\code{Charcter} value, method used to identify best match of 
cross correlation time slices with stretched master data set. One out of 
\code{"rmse"} (minimum root mean square error) and \code{"r"} (maximum 
R^2). Default is \code{"r"}.}

\item{reject}{\code{Numeric} value, rejection threshold for stretch values.
This value defines up to which quantile matching stretch solutions will 
be treated as valid solutions. Default is \code{0} (Only the minimum RMSE
value or the maximum R^2 value is returned, and the returned standard 
deviation will be NA). A change to \code{0.05} will return mean and 
standard deviation of the five best percent of the solutions.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
A \code{data.frame}, object with the time and relative wave 
velocity change estimate.
}
\description{
The function estimates the relative seismic wave velocity changes over 
time based on matching iteratively stretched master correlations to 
previously calculated correlograms (cf. \code{ncc_correlate}).
}
\examples{

\dontrun{

cc <- ncc_preprocess(start = "2017-04-09 00:30:00", 
                     stop = "2017-04-09 01:30:00", 
                     ID = c("RUEG1", "RUEG2"), 
                     component = c("Z", "Z"), 
                     dir = paste0(system.file("extdata", 
                                              package = "eseis"), "/"), 
                     window = 600, 
                     overlap = 0, 
                     lag = 20, 
                     deconvolve = TRUE, 
                     sensor = "TC120s",
                     logger = "Cube3extBOB",
                     gain = 1,
                     f = c(0.05, 0.1), 
                     sd = 1)
   
   ## estimate dv/v
   dv <- ncc_stretch(data = cc, range = 0.05)
   
   ## plot result
   plot(dv$time, dv$dvv, type = "l")
                     
}           
                                                              
}
\author{
Michael Dietze
}
\keyword{eseis}
