% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeTimeLag.R
\name{computeTimeLag}
\alias{computeTimeLag}
\title{computeTimeLag}
\usage{
computeTimeLag(esDf, RELEVANTVN_ES)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
\code{esDf} with 3 additional columns
\enumerate{
\item ST_DATETIME. Date-time object of scheduled start time of the single ESM questionnaire.
\item TIME_LAG. The duration between the scheduled start of a single ESM questionnaire and its' actual start time.
\item LAG_PA. Dichotomous variable, specifying whether the actual start was prior (P) to the scheduled time (LAG_PA = 0) or afterwards (A) (LAG_PA = 1).
}
}
\description{
computeTimeLag computes the duration between the scheduled prompt and the actual start of an ESM questionnaire as well as whether it was started before or after the prompt.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute computeTimeLag. Start -----------
# RELEVANTINFO_ES is delivered with the package
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
intoleranceDf <- data.frame(prompt = c(2, 3, 4, 1, 1),
expect = c(1, 1, 1, 2, 3))
# expectedDf is a raw ESM dataset, delivered with the package.
intolLs <- intolerable(expectedDf, intoleranceDf, RELEVANTINFO_ES)
randSelLs <- randomMultSelection(intolLs[["cleanedDf"]])
# Prerequisites in order to execute computeTimeLag. End -------------
# -------------------------------------------------------
# Run function 26 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# randSelLs[["esRandSelIn"]] is the result of function 'randomMultSelection'.
lagDf <- computeTimeLag(randSelLs[["esRandSelIn"]], RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 26 of 29).
}
