% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esFinal.R
\name{esFinal}
\alias{esFinal}
\title{esFinal}
\usage{
esFinal(esDf, esOpt = NULL, complianceRate = NULL,
  RELEVANTINFO_ES = NULL, RELEVANTVN_ES = NULL, maxRows = NULL)
}
\arguments{
\item{esDf}{a data.frame. A single ESM dataset. It must contain the 2 columns that hold the date-time object for when an ESM questionnaire was started and finished, respectively.}

\item{esOpt}{a data.frame. This data.frame is generated as part of a list returned by the function \code{\link{esAssign}}. The name of this list's element is \code{ESopt}. Extract this element and pass it to the argument \code{esOpt} of this function.}

\item{complianceRate}{integer. This value must be set to a value between 0 and 100. If you want to have the completion rates for all participants and you also want to make sure that all participants are kept in the final ESM dataset, simply set the argument \code{complianceRate} to 0.}

\item{RELEVANTINFO_ES}{a list. This list is generated by function \code{\link{setES}}.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{maxRows}{a numeric value. The number of data lines (per participant)  in the final event sampling dataset; must be equal for all participants. If no number is entered the maximum number across all participants is used.}
}
\value{
The user receives a list containing 3 elements:
\enumerate{
\item ESfinal, i.e. with empty rows of data added and with 2 additional columns MISSED and FILLER. MISSED refers to questionnaires that should have been answered by the participants but weren't. FILLER refers to empty rows of data due to all participants having to have equally many rows of data for multilevel modeling. See \strong{Details} for more information..
\item ESrateFinal, i.e. the average completion rates per participant, both per prompt and overall.
\item ESfinalOut, i.e. ESM data that contains participants that won't be used for statistical analyses due to having less than a minimum number of answered ESM questionnaires. If no participant is deselected a character string is returned that affirms that no deselection took place.
}
Unlike the interim result returned by the function \code{\link{esAssign}} (whenever there was at least one daily prompt) the data.frame \code{ESrateFinal} shows the final completion rates per participant.
}
\description{
esFinal generates the final ESM dataset.
}
\details{
The empty rows will either denote ESM questionnaires that were missed by the participant or it will denote fillers, i.e. rows of empty data to fill up the number of rows to be equal across all participants The number of maximum rows per participant either are computed by searching the actual maximum number of questionnaires started by the participant, or by what the user defines to be the maximum number of questionnaires (no less than 2).
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute esFinal. Start ------------------
# RELEVANTINFO_ES is delivered with the package
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# tbsqDf is a raw ESM dataset, delivered with the package.
# Prerequisites in order to execute esFinal. End --------------------
# -------------------------------------------------------
# Run function 29 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# tbsqDf is the result of function 'computeTimeBetween'.
esDfFin <- esFinal(tbsqDf, esOpt=esAssigned[["ESopt"]], complianceRate=50,
RELEVANTINFO_ES, RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 29 of 29).
}
