% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClimPalette.R
\name{ClimPalette}
\alias{ClimPalette}
\alias{ClimColors}
\title{Generate Climate Color Palettes}
\usage{
ClimPalette(palette = "bluered")

ClimColors(n, palette = "bluered")
}
\arguments{
\item{palette}{A character string of palette. The current choices:
\itemize{
  \item{'bluered': from blue through white to red.} 
  \item{'redblue': from red through white to blue.}
  \item{'yellowred': from yellow through orange to red.}
  \item{'redyellow': from red through orange to yellow.}
  \item{'purpleorange': from purple through white to orange.}
  \item{'orangepurple': from orange through white to purple.}
}}

\item{n}{A number indicating how many colors to generate.}
}
\value{
ClimPalette() returns the function that generates the color palette and the 
attribute 'na_color'.\cr
ClimColors() returns a vector of the colors.
}
\description{
Generates a colorblind friendly color palette with color ranges useful in 
climate temperature variable plotting.
}
\examples{
lims <- seq(-1, 1, length.out = 21)
cb <- ColorBarContinuous(lims, color_fun = ClimPalette('redyellow'), plot = FALSE)

cols <- ClimColors(20)
cb <- ColorBarContinuous(lims, cols, plot = FALSE)

}
