% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.R
\name{nodeapply}
\alias{nodeapply}
\alias{nodeapply.partynode}
\alias{nodeapply.etree}
\alias{nodeapply.party}
\title{Apply functions over nodes}
\usage{
nodeapply(obj, ids = 1, FUN = NULL, ...)

\method{nodeapply}{partynode}(obj, ids = 1, FUN = NULL, ...)

\method{nodeapply}{etree}(obj, ids = 1, FUN = NULL, by_node = TRUE, ...)
}
\arguments{
\item{obj}{Object of class \code{"etree"} or \code{"partynode"}.}

\item{ids}{Integer vector of node identifiers to apply over.}

\item{FUN}{Function to be applied to nodes. By default, the node itself is
returned.}

\item{...}{Additional arguments.}

\item{by_node}{Logical indicating whether FUN should be applied to subsets of
\code{"partynode"} objects (default) or not, in which case it is applied to
subsets of \code{"etree"} objects.}
}
\value{
A list of results whose length is given by \code{length(ids)}.
}
\description{
Returns a list of values obtained by applying a function to \code{"etree"} or
\code{"partynode"} objects.
}
\details{
The method for \code{"partynode"} objects apply function \code{FUN} to all
nodes with node identifiers in \code{ids}. The method for \code{"etree"}
objects by default calls the \code{nodeapply} method on the corresponding
node slot. If \code{by_node} is \code{FALSE}, it is applied to the
\code{"etree"} object with root node \code{ids}.
}
\section{Methods (by class)}{
\itemize{
\item \code{partynode}: nodeapply() method for objects of class "partynode".

\item \code{etree}: nodeapply() method for objects of class "etree".
}}

\examples{

\donttest{

## Covariates
nobs <- 100
cov_num <- rnorm(nobs)
cov_nom <- factor(rbinom(nobs, size = 1, prob = 0.5))
cov_gph <- lapply(1:nobs, function(j) igraph::sample_gnp(100, 0.2))
cov_fun <- fda.usc::rproc2fdata(nobs, seq(0, 1, len = 100), sigma = 1)
cov_list <- list(cov_num, cov_nom, cov_gph, cov_fun)

## Response variable
resp_reg <- cov_num ^ 2

## Fit
etree_fit <- etree(response = resp_reg, covariates = cov_list)

## Get pvalues of inner nodes
tnodes <- nodeids(etree_fit, terminal = TRUE)
nodes <- 1:max(tnodes)
inodes <- nodes[-tnodes]
nodeapply(etree_fit, ids = inodes, FUN = function(n) n$info$pvalue)
}
}
