% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_geo_data.R
\name{download_geo_data}
\alias{download_geo_data}
\title{Download GEO Data Resources}
\usage{
download_geo_data(
  gse_id,
  dest_dir,
  overwrite = FALSE,
  log = TRUE,
  log_file = NULL,
  retries = 2,
  timeout = 300
)
}
\arguments{
\item{gse_id}{Character. GEO Series accession ID (e.g., "GSE12345").}

\item{dest_dir}{Character. Destination directory for downloaded files.}

\item{overwrite}{Logical. Whether to overwrite existing files (default: FALSE).}

\item{log}{Logical. Whether to create log file (default: TRUE).}

\item{log_file}{Character or NULL. Log file path (auto-generated if NULL).}

\item{retries}{Numeric. Number of retry attempts (default: 2).}

\item{timeout}{Numeric. Timeout in seconds (default: 300).}
}
\value{
A list with components:
\describe{
\item{gse_object}{ExpressionSet object with expression data and annotations}
\item{supplemental_files}{Paths to downloaded supplemental files}
\item{platform_info}{Platform information (platform_id, gpl_files)}
\item{meta}{Download metadata (timing, file counts, etc.)}
}
}
\description{
Downloads GEO (Gene Expression Omnibus) datasets including expression data,
supplemental files, and platform annotations with error handling and logging.
}
\details{
Downloads GSEMatrix files, supplemental files, and GPL annotations.
Includes retry mechanism, timeout control, and logging.
Requires: GEOquery, Biobase, withr, cli.
}
\examples{
\dontrun{
# Download GEO data (requires network connection):
result <- download_geo_data("GSE12345", dest_dir = tempdir())

# Advanced usage with custom settings:
result <- download_geo_data(
  gse_id = "GSE7305",
  dest_dir = tempdir(),
  log = TRUE,
  retries = 3,
  timeout = 600
)

# Access downloaded data:
expr_data <- Biobase::exprs(result$gse_object)
sample_info <- Biobase::pData(result$gse_object)
feature_info <- Biobase::fData(result$gse_object)
}

}
\references{
\url{https://www.ncbi.nlm.nih.gov/geo/}

Barrett T, Wilhite SE, Ledoux P, Evangelista C, Kim IF, Tomashevsky M,
Marshall KA, Phillippy KH, Sherman PM, Holko M, Yefanov A, Lee H,
Zhang N, Robertson CL, Serova N, Davis S, Soboleva A. NCBI GEO: archive
for functional genomics data sets--update. Nucleic Acids Res. 2013 Jan;
41(Database issue):D991-5.
}
