% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_version.R
\name{pkg_version}
\alias{pkg_version}
\title{pkg_version: Check Installed and Latest Versions of R Packages}
\usage{
pkg_version(pkg, preview = TRUE)
}
\arguments{
\item{pkg}{Character vector of package names.}

\item{preview}{Logical. If TRUE, print the result to console.}
}
\value{
A data.frame with columns: package, version (installed),
latest (available), and source.
}
\description{
This function checks the installed and latest available versions of
R packages across CRAN, Bioconductor, and GitHub.
It supports case-insensitive matching and smart console previews.
}
\examples{
\dontrun{
# Check versions of multiple packages (requires network):
pkg_version(c("ggplot2", "dplyr"))

# Check with preview disabled:
result <- pkg_version(c("ggplot2", "limma"), preview = FALSE)
}

\donttest{
# Quick demo with base R package:
try(pkg_version("base", preview = FALSE))
}
}
