% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{checkData}
\alias{checkData}
\title{Check the entered data against the data dictionary}
\usage{
checkData(dictionary, data, id)
}
\arguments{
\item{dictionary}{A data frame returned by readDataDict}

\item{data}{A data frame returned by readExcelData}

\item{id}{String indicating the ID variable, to display errors by ID instead
of row number}
}
\value{
A list with various reports of errors and duplicates
\itemize{
  \item errors_by_row - A data frame with errors by rownumber, or ID if supplied
  \item errors_by_variable - A data frame containing all errors by variable
  \item duplicated_entries - A string containing a list of duplicated entries
  \item error_dataframe - A data frame containing all the rows and columns
  with errors and Boolean values indicating if the entry is an error
}
}
\description{
This function compares the data in the data entry table against the
specifications in the dictionary
}
\details{
Prior to reading in the data, the dictionary must be imported using
readDataDict and the data must be imported using readExcelData.

The function will check all variables in the dictionary. If variables are
missing from the dictionary an error will occur. If variables are missing
from the data table a warning will be shown.
}
\examples{
\dontrun{
exampleDataFile <- system.file("extdata", "exampleData.xlsx", package = "exceldata")

dictionary <- readDataDict(exampleDataFile, dictionarySheet = 'DataDictionary')
data <- readExcelData(exampleDataFile,dictionary,dataSheet='DataEntry')
checks <- checkData(dictionary,data,'ID')

exampleDataFile <- system.file("extdata", "exampleData_withErrors.xlsx", package = "exceldata")

dictionary <- readDataDict(exampleDataFile, dictionarySheet = 'DataDictionary')
data <- readExcelData(exampleDataFile,dictionary,dataSheet='DataEntry')
checks <- checkData(dictionary,data,'ID')

checks
}
}
