% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_exif.R
\name{read_exif}
\alias{read_exif}
\title{Read EXIF data from files}
\usage{
read_exif(path, tags = NULL, recursive = FALSE, args = NULL, quiet = TRUE)
}
\arguments{
\item{path}{A vector of filenames}

\item{tags}{A vector of tags to output. It is a good idea to specify this
when reading large numbers of files, as it decreases the output overhead
significantly. Spaces will be stripped in the output data frame. This
parameter is not case-sensitive.}

\item{recursive}{TRUE to pass the "-r" option to ExifTool}

\item{args}{Additional arguments}

\item{quiet}{Use FALSE to display diagnostic information}
}
\value{
A data frame (tibble) with columns SourceFile and one per tag read in
  each file. The number of rows may differ, particularly if recursive is set
  to TRUE, but in general will be one per file.
}
\description{
Reads EXIF data into a \code{data.frame} by calling the ExifTool command-line
application, written by Phil Harvey. Depending on number of images and
command-line length requirements, the command may be called multiple times.
}
\details{
From the \href{https://exiftool.org}{ExifTool
website}: ExifTool is a platform-independent Perl library plus a command-line
application for reading, writing and editing meta information in a wide
variety of files. ExifTool supports many different metadata formats including
EXIF, GPS, IPTC, XMP, JFIF, GeoTIFF, ICC Profile, Photoshop IRB, FlashPix,
AFCP and ID3, as well as the maker notes of many digital cameras by Canon,
Casio, FLIR, FujiFilm, GE, HP, JVC/Victor, Kodak, Leaf,
Minolta/Konica-Minolta, Motorola, Nikon, Nintendo, Olympus/Epson,
Panasonic/Leica, Pentax/Asahi, Phase One, Reconyx, Ricoh, Samsung, Sanyo,
Sigma/Foveon and Sony. For more information, see the
\href{https://exiftool.org}{ExifTool website}.

Note that binary tags such as thumbnails are loaded as base64-encoded
strings that start with "base64:".
}
\examples{
files <- list.files(path.package("exifr"), recursive=TRUE, pattern="*.jpg", full.names=TRUE)
exifinfo <- read_exif(files)
# is equivalent to
exifinfo <- read_exif(path.package("exifr"), recursive=TRUE)

read_exif(files, tags=c("filename", "imagesize"))

}
