% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{print.plot_expirest_wisle}
\alias{print.plot_expirest_wisle}
\title{Print a plot illustrating the what-if shelf life estimation (wisle)}
\usage{
\method{print}{plot_expirest_wisle}(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{plot_expirest_wisle}} returned by
the \code{\link{plot_expirest_wisle}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[base]{formatC}()} function.}
}
\value{
The \sQuote{\code{plot_expirest_wisle}} object passed to the \code{x}
parameter is returned invisibly.
}
\description{
This is a method for the function \code{print()} for objects of class
\sQuote{\code{plot_expirest_wisle}}.
}
\details{
The element \code{Graph} of the \sQuote{\code{plot_expirest_wisle}}
object that is returned by the function \code{\link{plot_expirest_wisle}()}
is an object of class \sQuote{\code{ggplot}}, generated by the function
\code{\link[ggplot2]{ggplot}()} from the \sQuote{\code{ggplot2}} package.
Thus, the corresponding \code{plot} method is used for plotting. Arguments
to the \code{\link[ggplot2]{ggplot}()} function can be passed via the
\code{...} parameter.
}
\examples{
# Performing a "what-if (approach for) shelf life estimation" (wisle)
res1 <-
  expirest_wisle(data = exp1[exp1$Batch \%in\% c("b2", "b5", "b7"), ],
                 response_vbl = "Potency", time_vbl = "Month",
                 batch_vbl = "Batch", rl = 98, rl_sf = 3, sl = 95,
                 sl_sf = 3, srch_range = c(0, 500), sf_option = "loose")

# The 'expirest_wisle' object can be passed on to the plot_expirest_wisle()
# function. This function does not produce any output but returns a
# 'plot_expirest_wisle' object.
\dontrun{
  gg1 <- plot_expirest_wisle(
    model = res1, rl_index = 1, response_vbl_unit = "\%", x_range = NULL,
    y_range = c(93, 105), scenario = "standard", mtbs = "verified",
    plot_option = "full", ci_app = "line")
  gg2 <- print(gg1)

  # The print() function returns the 'plot_expirest_wisle' object invisibly.
  class(gg1)
  class(gg2)
}
}
\seealso{
\code{\link{expirest_wisle}}, \code{\link{plot_expirest_wisle}},
\code{\link[ggplot2]{ggplot}()}, \code{\link[utils]{methods}}.
}
