% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.plot.R
\name{index.plot}
\alias{index.plot}
\title{Function which plots the index for differents forecasts sharing the same observations}
\usage{
index.plot(forecasts, col = NULL, leg = NULL, xtypq = TRUE, ...)
}
\arguments{
\item{forecasts}{list of "indexfore" objects, all forecasts must be computed on the same climatology and thresholds}

\item{col}{colors of the differents forecasts for the plot}

\item{leg}{legend of the plot}

\item{xtypq}{the x-axis of the plot is quantiles values or orders (TRUE for quantiles)}

\item{...}{other arguments for the plot}
}
\value{
a plot of the indices and a matrix containing the indexes for each threshold/order
}
\description{
Function which plots the index for differents forecasts sharing the same observations
}
\examples{
data("crps")
y=crps[1:500,1]
cli=indexclim(y,thresh=seq(3,quantile(y,probs=0.995),length=2),xi=0.2)
frcst=crps[1:500,2]
idf=indexfore(frcst,cli)
frcst=crps[1:500,3]
idf2=indexfore(frcst,cli)
fore=list(idf,idf2)
idxp2=index.plot(fore,col=c("red","blue"),leg=c("forecast 1",
"forecast 2"),main="Index plot")
}
