% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{impute}
\alias{impute}
\title{Functional Imputation}
\usage{
impute(
  X,
  method = c("zero", "mean_obs", "median_obs", "mean_data", "median_data", "linear",
    "functional"),
  obs_share_data = FALSE
)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{method}{String to indicate method of imputation.
\itemize{
\item zero: Fill missing values with 0.
\item mean_obs: Fill missing values with the mean of each observation.
\item median_obs: Fill missing values with the median of each observation.
\item mean_data: Fill missing values with the mean of the data at that
particular fparam value.
\item median_data: Fill missing values with the median of the data at that
particular fparam value.
\item linear: Fill missing values with linear interpolation.
\item functional: Fill missing values with functional interpolation. This
is done by fitting the data to basis with the package 'fda'.
}}

\item{obs_share_data}{Boolean in linear interpolation that indicates if
data should be shared across observations. For example, if the end of
observation i related to the start of observation i+1. Default is FALSE,
which suggests independence. If true, the distance between the end and
start of observations is taken to be the mean average distance of points in
fparam.}
}
\value{
A dfts object of the data with missing values interpolated.
}
\description{
Several basic imputation methods for missing values in functional data
formatted as dfts objects.
}
\examples{
temp <- data.frame(
  c(NA, NA, 3:9, NA),
  c(NA, stats::rnorm(2), NA, stats::rnorm(6)),
  stats::rnorm(10),
  c(stats::rnorm(4), rep(NA, 3), stats::rnorm(3)),
  rep(NA, 10),
  c(stats::rnorm(1), rep(NA, 9)),
  c(stats::rnorm(9), NA),
  stats::rnorm(10),
  stats::rnorm(10),
  c(NA, NA, 3:9, NA)
)
impute(temp, method = "mean_obs")
impute(temp, method = "linear", obs_share_data = TRUE)
}
