% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnetar.R
\name{NNETAR}
\alias{NNETAR}
\alias{report.NNETAR}
\title{Neural Network Time Series Forecasts}
\usage{
NNETAR(formula, n_nodes = NULL, n_networks = 20, scale_inputs = TRUE, ...)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{n_nodes}{Number of nodes in the hidden layer. Default is half of the
number of input nodes (including external regressors, if given) plus 1.}

\item{n_networks}{Number of networks to fit with different random starting
weights. These are then averaged when producing forecasts.}

\item{scale_inputs}{If TRUE, inputs are scaled by subtracting the column
means and dividing by their respective standard deviations. Scaling is
applied after transformations.}

\item{...}{Other arguments passed to \code{\link[nnet:nnet]{nnet::nnet()}}.}
}
\value{
A model specification.
}
\description{
Feed-forward neural networks with a single hidden layer and lagged inputs
for forecasting univariate time series.
}
\details{
A feed-forward neural network is fitted with lagged values of the response as
inputs and a single hidden layer with \code{size} nodes. The inputs are for
lags 1 to \code{p}, and lags \code{m} to \code{mP} where
\code{m} is the seasonal period specified.

If exogenous regressors are provided, its columns are also used as inputs.
Missing values are currently not supported by this model.
A total of \code{repeats} networks are
fitted, each with random starting weights. These are then averaged when
computing forecasts. The network is trained for one-step forecasting.
Multi-step forecasts are computed recursively.

For non-seasonal data, the fitted model is denoted as an NNAR(p,k) model,
where k is the number of hidden nodes. This is analogous to an AR(p) model
but with non-linear functions. For seasonal data, the fitted model is called
an NNAR(p,P,k)[m] model, which is analogous to an ARIMA(p,0,0)(P,0,0)[m]
model but with non-linear functions.
}
\section{Specials}{


\subsection{AR}{
The \code{AR} special is used to specify auto-regressive components in each of the
nodes of the neural network.

\preformatted{
AR(p = NULL, P = 1, period = NULL)
}

\tabular{ll}{
\code{p}        \tab The order of the non-seasonal auto-regressive (AR) terms. If \code{p = NULL}, an optimal number of lags will be selected for a linear AR(p) model via AIC. For seasonal time series, this will be computed on the seasonally adjusted data (via STL decomposition). \cr
\code{P}        \tab The order of the seasonal auto-regressive (SAR) terms. \cr
\code{period}   \tab The periodic nature of the seasonality. This can be either a number indicating the number of observations in each seasonal period, or text to indicate the duration of the seasonal window (for example, annual seasonality would be "1 year").
}
}

\subsection{xreg}{
Exogenous regressors can be included in an NNETAR model without explicitly using the \code{xreg()} special. Common exogenous regressor specials as specified in \code{\link{common_xregs}} can also be used. These regressors are handled using \code{\link[stats:model.frame]{stats::model.frame()}}, and so interactions and other functionality behaves similarly to \code{\link[stats:lm]{stats::lm()}}.
\preformatted{
xreg(...)
}

\tabular{ll}{
\code{...}      \tab Bare expressions for the exogenous regressors (such as \code{log(x)})
}
}
}

\examples{
as_tsibble(airmiles) \%>\%
  model(nn = NNETAR(box_cox(value, 0.15)))
}
\seealso{
\href{https://otexts.com/fpp2/nnetar.html}{Forecasting: Principles and Practices, Neural network models (section 11.3)}
}
