% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_text_add.R
\name{fabric_text_add}
\alias{fabric_text_add}
\title{Add text within preexisting canvas element}
\usage{
fabric_text_add(
  cid,
  textId,
  text,
  left = 100,
  top = 100,
  fill = "#2F3941",
  angle = 0,
  opacity = 1,
  fontFamily = "Comic Sans",
  fontSize = 40,
  fontStyle = "normal",
  strokecolor = "#282A36",
  strokewidth = 1,
  fontWeight = "normal",
  underline = FALSE,
  linethrough = FALSE,
  overline = FALSE,
  selectable = TRUE,
  shadow = FALSE,
  shadowCol = "#324C63",
  textAlign = "center",
  lineHeight = 1,
  textBackgroundColor = NULL
)
}
\arguments{
\item{cid}{the id of the canvas element}

\item{textId}{the id of the text}

\item{text}{the content of the text}

\item{left}{the text's position from the left relative to the canvas element. Defaults to 100}

\item{top}{the text's position from the top relative to the canvas element. Defaults to 100}

\item{fill}{the text's color. Defaults to '#2F3941' (dark shade of cyan-blue)}

\item{angle}{the angle of rotation of the text. Defaults to 0 (no rotation)}

\item{opacity}{text opacity (from 0 to 1). Defaults to 1}

\item{fontFamily}{the font family of the text. Defaults to 'Comic Sans'}

\item{fontSize}{text sizing. Defaults to 40}

\item{fontStyle}{the font style of the text. Either 'normal' or 'italic'}

\item{strokecolor}{the stroke color of the text Defaults to '#282A36' (Very dark grayish blue)}

\item{strokewidth}{the stroke width of the text. Defaults to 1}

\item{fontWeight}{allows the user to make text thicker or thinner. Keywords can be used ('normal', 'bold'), or numbers. Defaults to 'normal'}

\item{underline}{logical. Whether to underline the text or not. Defaults to FALSE}

\item{linethrough}{logical. Whether to insert a line through the text or not. Defaults to FALSE}

\item{overline}{logical. Whether to put a line above the text or not. Defaults to FALSE}

\item{selectable}{logical. If TRUE, the user can modify interactively the image's size, position and rotation. Defaults to TRUE}

\item{shadow}{logical. If TRUE a text shadow will be inserted behind the raw text. Defaults to FALSE}

\item{shadowCol}{the color of the text shadow. Defaults to #FFFAF0 (floral white)}

\item{textAlign}{the alignment of text. Useful when there are line breaks. Defaults to "center"}

\item{lineHeight}{the height of the line breaks.Defaults to 1}

\item{textBackgroundColor}{the background color of the text, defaults to NULL}
}
\value{
a text object within a preexisting canvas element
}
\description{
Add text within preexisting canvas element
}
\examples{

if (interactive()) {

ui <- fluidPage(


fabric_shape(cid = "canvas123",
             cfill = "lightblue",
             cwidth = 1000,
             shapeId = "tri1",
             shape = "Triangle",
             fill = "darkblue"),

fabric_text_add(cid = "canvas123",
                textId = "txt1",
                text = "This is a darkblue Triangle !",
                left = 350
                )

                )

server <- function(input, output) {}

shinyApp(ui = ui, server = server)


}
}
