% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{compliance_profile}
\alias{compliance_profile}
\title{Complier covariate profiles}
\usage{
compliance_profile(formula, data, subset)
}
\arguments{
\item{formula}{one-sided formula to indicate the treatment
assignment, treatment uptake, and covariates. The right-hand
side of the formula should have three components separated by
the \code{|} symbol, with the first component containing the K binary
treatment variables (treatment assignment), the second component
containing the K binary instruments associated with each
treatment variable (treatment uptake), and the third giving the
covariates to be included in the profile. The order of the
variables in the first two parts of the formula must match.}

\item{data}{a data.frame on which to apply the \code{formula}.}

\item{subset}{subset of the data to pass to estimation.}
}
\value{
A list with two objects:
\item{raw_table}{a data.frame whose rows represent the covariates and
whose columns represent the different compliance groups. Each
entry is the estimated mean of the covariate for that compliance
group. }
\item{std_table}{a data.frame similarly structured to raw_table
but with the standardized difference between the compilance group
means and the overall means in place of the raw means.}
}
\description{
Calculates averages of covariates by compliance group in a
2^K factorial setting.
}
\examples{

data(newhaven)

cov_prof <- compliance_profile(~ inperson + phone | inperson_rand
  + phone_rand | age + maj_party + turnout_96, data = newhaven)

cov_prof
}
\references{
Matthew Blackwell and Nicole Pashley (2021) "Noncompliance in
Factorial Experiments." Working paper.
}
\author{
Matthew Blackwell
}
