% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quants.R
\name{computeQuants}
\alias{computeQuants}
\title{Compute quantiles generic for the quantile learning step}
\usage{
computeQuants(x, data, newdata, ind, ...)
}
\arguments{
\item{x}{Object with an associated \code{computeQuants()} method, to be used for
inferring quantiles.}

\item{data}{\code{data.frame} containing samples used in the quantile
regression.}

\item{newdata}{\code{data.frame} containing counterfactual values for which
the quantiles need to be inferred.}

\item{ind}{A \code{logical} vector of length \code{nrow(data)}, indicating which
samples have the baseline value of the protected attribute.}

\item{...}{Additional arguments to be passed down to respective method
functions.}
}
\value{
A vector of counterfactual values corresponding to \code{newdata}.
}
\description{
Compute quantiles generic for the quantile learning step
}
