% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomGrouping.R
\name{create_randomised_groups}
\alias{create_randomised_groups}
\title{Create randomised groups Creates randomised groups, e.g. for tests that
depend on splitting (continuous) data into groups, such as the
Hosmer-Lemeshow test}
\usage{
create_randomised_groups(
  x,
  y = NULL,
  sample_identifiers,
  n_max_groups = NULL,
  n_min_groups = NULL,
  n_min_y_in_group = NULL,
  n_groups_init = 30,
  fast_mode = TRUE
)
}
\arguments{
\item{x}{Vector with data used for sorting. Groups are formed based on
adjacent values.}

\item{y}{Vector with markers, e.g. the events. Should be 0 or 1 (for an
event).}

\item{sample_identifiers}{data.table with sample_identifiers. If provide, a
list of grouped sample_identifiers will be returned, and integers
otherwise.}

\item{n_max_groups}{Maximum number of groups that need to be formed.}

\item{n_min_groups}{Minimum number of groups that need to be formed.}

\item{n_min_y_in_group}{Minimum number of y=1 in each group for a valid
group.}

\item{n_groups_init}{Number of initial groups (default: 30)}

\item{fast_mode}{Enables fast randomised grouping mode (default: TRUE)}
}
\value{
List of group sample ids or indices.
}
\description{
The default fast mode is based on random sampling, whereas the slow mode is
based on probabilistic joining of adjacent groups. As the name suggests, fast
mode operates considerably more efficient.
}
\details{
Creates randomised groups, e.g. for tests that depend on splitting
(continuous) data into groups, such as the Hosmer-Lemeshow test
\itemize{
\item Determine maximum number of groups: either 10 or number so that each group
has 5 events (if smaller).
\item Determine minimum number of groups (half the maximum, or 2). Groups cannot
the exceed corresponding group size.
\item Start with 50 very small groups.
\item Iterate while the maximum number of groups has not been reached.
\itemize{
\item Selection probability is 1/n_j
\item If a group exceeds the maximum group size, selection probability is 0.
\itemize{
\item Break if all groups have exceeded the maximum size.
}
\item Get cumulative probability and normalise by total.
\item Draw random number between 0 and 1.
\item Select the group which has a cumulative probability range that contains
the random number.
\item Draw a random number to decide whether to join the group with right or
left adjacent group, and assign the group number to the adjacent group.
Probability depends on the size of adjacent groups. Smaller sizes have
greater probability of being joined. No joining with groups already
exceeding the maximum group size. If surrounded on both sides, force
selection probability for current group to 0. If joining is possible,
update group size, and selection probability for the new group.
}
\item Check that 5 events are present in each group. For each group with < 5
events, try to join with neighbours.
\item Start over if the number of groups is smaller than the minimum number.
}
}
\keyword{internal}
