% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotInputArguments.R
\name{.check_input_plot_args}
\alias{.check_input_plot_args}
\title{Internal checks on common plot input arguments}
\usage{
.check_input_plot_args(
  x_range = waiver(),
  y_range = waiver(),
  x_n_breaks = waiver(),
  y_n_breaks = waiver(),
  x_breaks = waiver(),
  y_breaks = waiver(),
  conf_int = waiver(),
  conf_int_alpha = waiver(),
  conf_int_style = waiver(),
  conf_int_default = c("step", "ribbon", "none"),
  facet_wrap_cols = waiver(),
  x_label = waiver(),
  y_label = waiver(),
  x_label_shared = waiver(),
  y_label_shared = waiver(),
  rotate_x_tick_labels = waiver(),
  rotate_y_tick_labels = waiver(),
  legend_label = waiver(),
  combine_legend = waiver(),
  plot_title = waiver(),
  plot_sub_title = waiver(),
  caption = waiver()
)
}
\arguments{
\item{x_range}{(\emph{optional}) Value range for the x-axis.}

\item{y_range}{(\emph{optional}) Value range for the y-axis.}

\item{x_n_breaks}{(\emph{optional}) Number of breaks to show on the x-axis of the
plot. \code{x_n_breaks} is used to determine the \code{x_breaks} argument in case it
is unset.}

\item{y_n_breaks}{(\emph{optional}) Number of breaks to show on the y-axis of the
plot. \code{y_n_breaks} is used to determine the \code{y_breaks} argument in case it
is unset.}

\item{x_breaks}{(\emph{optional}) Break points on the x-axis of the plot.}

\item{y_breaks}{(\emph{optional}) Break points on the y-axis of the plot.}

\item{conf_int}{(\emph{optional})}

\item{conf_int_alpha}{(\emph{optional}) Alpha value to determine transparency of
confidence intervals or, alternatively, other plot elements with which the
confidence interval overlaps. Only values between 0.0 (fully transparent)
and 1.0 (fully opaque) are allowed.}

\item{conf_int_style}{(\emph{optional}) Confidence interval style. See details for
allowed styles.}

\item{conf_int_default}{Sets the default options for the confidence interval.}

\item{facet_wrap_cols}{(\emph{optional}) Number of columns to generate when facet
wrapping. If NULL, a facet grid is produced instead.}

\item{x_label}{(\emph{optional}) Label to provide to the x-axis. If NULL, no label
is shown.}

\item{y_label}{(\emph{optional}) Label to provide to the y-axis. If NULL, no label
is shown.}

\item{x_label_shared}{(\emph{optional}) Sharing of x-axis labels between facets.
One of three values:
\itemize{
\item \code{overall}: A single label is placed at the bottom of the figure. Tick
text (but not the ticks themselves) is removed for all but the bottom facet
plot(s).
\item \code{column}: A label is placed at the bottom of each column. Tick text (but
not the ticks themselves) is removed for all but the bottom facet plot(s).
\item \code{individual}: A label is placed below each facet plot. Tick text is kept.
}}

\item{y_label_shared}{(\emph{optional}) Sharing of y-axis labels between facets.
One of three values:
\itemize{
\item \code{overall}: A single label is placed to the left of the figure. Tick text
(but not the ticks themselves) is removed for all but the left-most facet
plot(s).
\item \code{row}: A label is placed to the left of each row. Tick text (but not the
ticks themselves) is removed for all but the left-most facet plot(s).
\item \code{individual}: A label is placed below each facet plot. Tick text is kept.
}}

\item{rotate_x_tick_labels}{(\emph{optional}) Rotate tick labels on the x-axis by
90 degrees. Defaults to \code{TRUE}. Rotation of x-axis tick labels may also be
controlled through the \code{ggtheme}. In this case, \code{FALSE} should be provided
explicitly.}

\item{rotate_y_tick_labels}{(\emph{optional}) Rotate tick labels on the y-axis by
45 degrees.}

\item{legend_label}{(\emph{optional}) Label to provide to the legend. If NULL, the
legend will not have a name.}

\item{combine_legend}{(\emph{optional}) Flag to indicate whether the same legend
is to be shared by multiple aesthetics, such as those specified by
\code{color_by} and \code{linetype_by} arguments.}

\item{plot_title}{(\emph{optional}) Label to provide as figure title. If NULL, no
title is shown.}

\item{plot_sub_title}{(\emph{optional}) Label to provide as figure subtitle. If
NULL, no subtitle is shown.}

\item{caption}{(\emph{optional}) Label to provide as figure caption. If NULL, no
caption is shown.}
}
\description{
Internal checks on common plot input arguments
}
\keyword{internal}
