% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotModelPerformance.R
\name{plot_model_performance}
\alias{plot_model_performance}
\alias{plot_model_performance,ANY-method}
\alias{plot_model_performance,familiarCollection-method}
\title{Plot model performance.}
\usage{
plot_model_performance(
  object,
  draw = FALSE,
  dir_path = NULL,
  split_by = NULL,
  x_axis_by = NULL,
  y_axis_by = NULL,
  color_by = NULL,
  facet_by = NULL,
  facet_wrap_cols = NULL,
  plot_type = NULL,
  ggtheme = NULL,
  discrete_palette = NULL,
  gradient_palette = NULL,
  gradient_palette_range = waiver(),
  x_label = waiver(),
  y_label = waiver(),
  legend_label = waiver(),
  plot_title = waiver(),
  plot_sub_title = waiver(),
  caption = NULL,
  rotate_x_tick_labels = waiver(),
  y_range = NULL,
  y_n_breaks = 5,
  y_breaks = NULL,
  width = waiver(),
  height = waiver(),
  units = waiver(),
  annotate_performance = NULL,
  export_collection = FALSE,
  ...
)

\S4method{plot_model_performance}{ANY}(
  object,
  draw = FALSE,
  dir_path = NULL,
  split_by = NULL,
  x_axis_by = NULL,
  y_axis_by = NULL,
  color_by = NULL,
  facet_by = NULL,
  facet_wrap_cols = NULL,
  plot_type = NULL,
  ggtheme = NULL,
  discrete_palette = NULL,
  gradient_palette = NULL,
  gradient_palette_range = waiver(),
  x_label = waiver(),
  y_label = waiver(),
  legend_label = waiver(),
  plot_title = waiver(),
  plot_sub_title = waiver(),
  caption = NULL,
  rotate_x_tick_labels = waiver(),
  y_range = NULL,
  y_n_breaks = 5,
  y_breaks = NULL,
  width = waiver(),
  height = waiver(),
  units = waiver(),
  annotate_performance = NULL,
  export_collection = FALSE,
  ...
)

\S4method{plot_model_performance}{familiarCollection}(
  object,
  draw = FALSE,
  dir_path = NULL,
  split_by = NULL,
  x_axis_by = NULL,
  y_axis_by = NULL,
  color_by = NULL,
  facet_by = NULL,
  facet_wrap_cols = NULL,
  plot_type = NULL,
  ggtheme = NULL,
  discrete_palette = NULL,
  gradient_palette = NULL,
  gradient_palette_range = waiver(),
  x_label = waiver(),
  y_label = waiver(),
  legend_label = waiver(),
  plot_title = waiver(),
  plot_sub_title = waiver(),
  caption = NULL,
  rotate_x_tick_labels = waiver(),
  y_range = NULL,
  y_n_breaks = 5,
  y_breaks = NULL,
  width = waiver(),
  height = waiver(),
  units = waiver(),
  annotate_performance = NULL,
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{familiarCollection} object, or one or more \code{familiarData}
objects, that will be internally converted to a \code{familiarCollection}
object. It is also possible to provide a \code{familiarEnsemble} or one or more
\code{familiarModel} objects together with the data from which data is computed
prior to export. Paths to such files can also be provided.}

\item{draw}{(\emph{optional}) Draws the plot if TRUE.}

\item{dir_path}{(\emph{optional}) Path to the directory where created performance
plots are saved to. Output is saved in the \code{performance} subdirectory. If
\code{NULL} no figures are saved, but are returned instead.}

\item{split_by}{(\emph{optional}) Splitting variables. This refers to column names
on which datasets are split. A separate figure is created for each split.
See details for available variables.}

\item{x_axis_by}{(\emph{optional}) Variable plotted along the x-axis of a plot.
The variable cannot overlap with variables provided to the \code{split_by} and
\code{y_axis_by} arguments (if used), but may overlap with other arguments. Only
one variable is allowed for this argument. See details for available
variables.}

\item{y_axis_by}{(\emph{optional}) Variable plotted along the y-axis of a plot.
The variable cannot overlap with variables provided to the \code{split_by} and
\code{x_axis_by} arguments (if used), but may overlap with other arguments. Only
one variable is allowed for this argument. See details for available
variables.}

\item{color_by}{(\emph{optional}) Variables used to determine fill colour of plot
objects. The variables cannot overlap with those provided to the \code{split_by}
argument, but may overlap with other arguments. See details for available
variables.}

\item{facet_by}{(\emph{optional}) Variables used to determine how and if facets of
each figure appear. In case the \code{facet_wrap_cols} argument is \code{NULL}, the
first variable is used to define columns, and the remaing variables are
used to define rows of facets. The variables cannot overlap with those
provided to the \code{split_by} argument, but may overlap with other arguments.
See details for available variables.}

\item{facet_wrap_cols}{(\emph{optional}) Number of columns to generate when facet
wrapping. If NULL, a facet grid is produced instead.}

\item{plot_type}{(\emph{optional}) Type of plot to draw. This is one of \code{heatmap}
(draws a heatmap), \code{barplot} (draws a barplot with confidence intervals),
\code{boxplot} (draws a boxplot) and \code{violinplot} (draws a violin plot).
Defaults to \code{violinplot}.

The choice for \code{plot_type} affects several other arguments, e.g. \code{color_by}
is not used for \code{heatmap} and \code{y_axis_by} is only used by \code{heatmap}.}

\item{ggtheme}{(\emph{optional}) \code{ggplot} theme to use for plotting.}

\item{discrete_palette}{(\emph{optional}) Palette to use to color the different
plot elements in case a value was provided to the \code{color_by} argument. Only
used when \code{plot_type} is not \code{heatmap}.}

\item{gradient_palette}{(\emph{optional}) Sequential or divergent palette used to
color the raster in \code{heatmap} plots. This argument is not used for other
\code{plot_type} value.}

\item{gradient_palette_range}{(\emph{optional}) Numerical range used to span the
gradient. This should be a range of two values, e.g. \code{c(0, 1)}. Lower or
upper boundary can be unset by using \code{NA}. If not set, the full
metric-specific range is used.}

\item{x_label}{(\emph{optional}) Label to provide to the x-axis. If NULL, no label
is shown.}

\item{y_label}{(\emph{optional}) Label to provide to the y-axis. If NULL, no label
is shown.}

\item{legend_label}{(\emph{optional}) Label to provide to the legend. If NULL, the
legend will not have a name.}

\item{plot_title}{(\emph{optional}) Label to provide as figure title. If NULL, no
title is shown.}

\item{plot_sub_title}{(\emph{optional}) Label to provide as figure subtitle. If
NULL, no subtitle is shown.}

\item{caption}{(\emph{optional}) Label to provide as figure caption. If NULL, no
caption is shown.}

\item{rotate_x_tick_labels}{(\emph{optional}) Rotate tick labels on the x-axis by
90 degrees. Defaults to \code{TRUE}. Rotation of x-axis tick labels may also be
controlled through the \code{ggtheme}. In this case, \code{FALSE} should be provided
explicitly.}

\item{y_range}{(\emph{optional}) Value range for the y-axis.}

\item{y_n_breaks}{(\emph{optional}) Number of breaks to show on the y-axis of the
plot. \code{y_n_breaks} is used to determine the \code{y_breaks} argument in case it
is unset.}

\item{y_breaks}{(\emph{optional}) Break points on the y-axis of the plot.}

\item{width}{(\emph{optional}) Width of the plot. A default value is derived from
the number of facets.}

\item{height}{(\emph{optional}) Height of the plot. A default value is derived
from the number of features and the number of facets.}

\item{units}{(\emph{optional}) Plot size unit. Either \code{cm} (default), \code{mm} or
\verb{in}.}

\item{annotate_performance}{(\emph{optional}) Indicates whether performance in
heatmaps should be annotated with text. Can be \code{none}, \code{value} (default),
or \code{value_ci} (median value plus 95\% credibility intervals).}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=extract_performance]{extract_performance}}, \code{\link[=as_familiar_collection]{as_familiar_collection}}, \code{\link[ggplot2:ggsave]{ggplot2::ggsave}}
  \describe{
    \item{\code{data}}{A \code{dataObject} object, \code{data.table} or \code{data.frame} that
constitutes the data that are assessed.}
    \item{\code{is_pre_processed}}{Flag that indicates whether the data was already
pre-processed externally, e.g. normalised and clustered. Only used if the
\code{data} argument is a \code{data.table} or \code{data.frame}.}
    \item{\code{cl}}{Cluster created using the \code{parallel} package. This cluster is then
used to speed up computation through parallellisation.}
    \item{\code{evaluation_times}}{One or more time points that are used for in analysis of
survival problems when data has to be assessed at a set time, e.g.
calibration. If not provided explicitly, this parameter is read from
settings used at creation of the underlying \code{familiarModel} objects. Only
used for \code{survival} outcomes.}
    \item{\code{ensemble_method}}{Method for ensembling predictions from models for the
same sample. Available methods are:
\itemize{
\item \code{median} (default): Use the median of the predicted values as the ensemble
value for a sample.
\item \code{mean}: Use the mean of the predicted values as the ensemble value for a
sample.
}}
    \item{\code{metric}}{One or more metrics for assessing model performance. See the
vignette on performance metrics for the available metrics. If not provided
explicitly, this parameter is read from settings used at creation of the
underlying \code{familiarModel} objects.}
    \item{\code{verbose}}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}
    \item{\code{message_indent}}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}
    \item{\code{detail_level}}{(\emph{optional}) Sets the level at which results are computed
and aggregated.
\itemize{
\item \code{ensemble}: Results are computed at the ensemble level, i.e. over all
models in the ensemble. This means that, for example, bias-corrected
estimates of model performance are assessed by creating (at least) 20
bootstraps and computing the model performance of the ensemble model for
each bootstrap.
\item \code{hybrid} (default): Results are computed at the level of models in an
ensemble. This means that, for example, bias-corrected estimates of model
performance are directly computed using the models in the ensemble. If there
are at least 20 trained models in the ensemble, performance is computed for
each model, in contrast to \code{ensemble} where performance is computed for the
ensemble of models. If there are less than 20 trained models in the
ensemble, bootstraps are created so that at least 20 point estimates can be
made.
\item \code{model}: Results are computed at the model level. This means that, for
example, bias-corrected estimates of model performance are assessed by
creating (at least) 20 bootstraps and computing the performance of the model
for each bootstrap.
}

Note that each level of detail has a different interpretation for bootstrap
confidence intervals. For \code{ensemble} and \code{model} these are the confidence
intervals for the ensemble and an individual model, respectively. That is,
the confidence interval describes the range where an estimate produced by a
respective ensemble or model trained on a repeat of the experiment may be
found with the probability of the confidence level. For \code{hybrid}, it
represents the range where any single model trained on a repeat of the
experiment may be found with the probability of the confidence level. By
definition, confidence intervals obtained using \code{hybrid} are at least as
wide as those for \code{ensemble}. \code{hybrid} offers the correct interpretation if
the goal of the analysis is to assess the result of a single, unspecified,
model.

\code{hybrid} is generally computationally less expensive then \code{ensemble}, which
in turn is somewhat less expensive than \code{model}.

A non-default \code{detail_level} parameter can be specified for separate
evaluation steps by providing a parameter value in a named list with data
elements, e.g. \code{list("auc_data"="ensemble", "model_performance"="hybrid")}.
This parameter can be set for the following data elements: \code{auc_data},
\code{decision_curve_analyis}, \code{model_performance}, \code{permutation_vimp},
\code{ice_data}, \code{prediction_data} and \code{confusion_matrix}.}
    \item{\code{estimation_type}}{(\emph{optional}) Sets the type of estimation that should be
possible. This has the following options:
\itemize{
\item \code{point}: Point estimates.
\item \code{bias_correction} or \code{bc}: Bias-corrected estimates. A bias-corrected
estimate is computed from (at least) 20 point estimates, and \code{familiar} may
bootstrap the data to create them.
\item \code{bootstrap_confidence_interval} or \code{bci} (default): Bias-corrected
estimates with bootstrap confidence intervals (Efron and Hastie, 2016). The
number of point estimates required depends on the \code{confidence_level}
parameter, and \code{familiar} may bootstrap the data to create them.
}

As with \code{detail_level}, a non-default \code{estimation_type} parameter can be
specified for separate evaluation steps by providing a parameter value in a
named list with data elements, e.g. \code{list("auc_data"="bci", "model_performance"="point")}. This parameter can be set for the following
data elements: \code{auc_data}, \code{decision_curve_analyis}, \code{model_performance},
\code{permutation_vimp}, \code{ice_data}, and \code{prediction_data}.}
    \item{\code{aggregate_results}}{(\emph{optional}) Flag that signifies whether results
should be aggregated during evaluation. If \code{estimation_type} is
\code{bias_correction} or \code{bc}, aggregation leads to a single bias-corrected
estimate. If \code{estimation_type} is \code{bootstrap_confidence_interval} or \code{bci},
aggregation leads to a single bias-corrected estimate with lower and upper
boundaries of the confidence interval. This has no effect if
\code{estimation_type} is \code{point}.

The default value is equal to \code{TRUE} except when assessing metrics to assess
model performance, as the default violin plot requires underlying data.

As with \code{detail_level} and \code{estimation_type}, a non-default
\code{aggregate_results} parameter can be specified for separate evaluation steps
by providing a parameter value in a named list with data elements, e.g.
\code{list("auc_data"=TRUE, , "model_performance"=FALSE)}. This parameter exists
for the same elements as \code{estimation_type}.}
    \item{\code{confidence_level}}{(\emph{optional}) Numeric value for the level at which
confidence intervals are determined. In the case bootstraps are used to
determine the confidence intervals bootstrap estimation, \code{familiar} uses the
rule of thumb \eqn{n = 20 / ci.level} to determine the number of required
bootstraps.

The default value is \code{0.95}.}
    \item{\code{bootstrap_ci_method}}{(\emph{optional}) Method used to determine bootstrap
confidence intervals (Efron and Hastie, 2016). The following methods are
implemented:
\itemize{
\item \code{percentile} (default): Confidence intervals obtained using the percentile
method.
\item \code{bc}: Bias-corrected confidence intervals.
}

Note that the standard method is not implemented because this method is
often not suitable due to non-normal distributions. The bias-corrected and
accelerated (BCa) method is not implemented yet.}
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object}
parameter is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
    \item{\code{device}}{Device to use. Can either be a device function
(e.g. \link{png}), or one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only). If
\code{NULL} (default), the device is guessed based on the \code{filename} extension.}
    \item{\code{scale}}{Multiplicative scaling factor.}
    \item{\code{dpi}}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Applies only to raster output types.}
    \item{\code{limitsize}}{When \code{TRUE} (the default), \code{ggsave()} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}
    \item{\code{bg}}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}
    \item{\code{create.dir}}{Whether to create new directories if a non-existing
directory is specified in the \code{filename} or \code{path} (\code{TRUE}) or return an
error (\code{FALSE}, default). If \code{FALSE} and run in an interactive session,
a prompt will appear asking to create a new directory when necessary.}
  }}
}
\value{
\code{NULL} or list of plot objects, if \code{dir_path} is \code{NULL}.
}
\description{
This method creates plots that show model performance from the
data stored in a familiarCollection object. This method may create several
types of plots, as determined by \code{plot_type}.
}
\details{
This function plots model performance based on empirical bootstraps,
using various plot representations.

Available splitting variables are: \code{fs_method}, \code{learner}, \code{data_set},
\code{evaluation_time} (survival outcome only) and \code{metric}. The default for
\code{heatmap} is to split by \code{metric}, facet by \code{data_set} and
\code{evaluation_time}, position \code{learner} along the x-axis and \code{fs_method}
along the y-axis. The \code{color_by} argument is not used. The only valid
options for \code{x_axis_by} and \code{y_axis_by} are \code{learner} and \code{fs_method}.

For other plot types (\code{barplot}, \code{boxplot} and \code{violinplot}), depends on
the number of learners and feature selection methods:
\itemize{
\item \emph{one feature selection method and one learner}: the default is to split by
\code{metric}, and have \code{data_set} along the x-axis.
\item \emph{one feature selection and multiple learners}: the default is to split by
\code{metric}, facet by \code{data_set} and have \code{learner} along the x-axis.
\item \emph{multiple feature selection methods and one learner}: the default is to
split by \code{metric}, facet by \code{data_set} and have \code{fs_method} along the
x-axis.
\item \emph{multiple feature selection methods and learners}: the default is to split
by \code{metric}, facet by \code{data_set}, colour by \code{fs_method} and have \code{learner}
along the x-axis.
}

If applicable, additional faceting is performed for \code{evaluation_time}.

Available palettes for \code{discrete_palette} and \code{gradient_palette} are those
listed by \code{grDevices::palette.pals()} (requires R >= 4.0.0),
\code{grDevices::hcl.pals()} (requires R >= 3.6.0) and \code{rainbow}, \code{heat.colors},
\code{terrain.colors}, \code{topo.colors} and \code{cm.colors}, which correspond to the
palettes of the same name in \code{grDevices}. If not specified, a default
palette based on palettes in Tableau are used. You may also specify your
own palette by using colour names listed by \code{grDevices::colors()} or
through hexadecimal RGB strings.

Labeling methods such as \code{set_fs_method_names} or \code{set_data_set_names} can
be applied to the \code{familiarCollection} object to update labels, and order
the output in the figure.
}
