% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_score.R
\name{quantile_score}
\alias{quantile_score}
\title{Quantile score (pinball loss)}
\usage{
quantile_score(x, xhat, tau)
}
\arguments{
\item{x}{Numeric vector of observed values.}

\item{xhat}{Numeric vector of estimated quantiles.}

\item{tau}{Numeric vector of quantile levels in \verb{(0, 1)}.}
}
\value{
Numeric vector of quantile scores corresponding to each element of
the recycled inputs.
}
\description{
Computes the asymmetric absolute loss commonly used to assess quantile
forecasts. Lower scores indicate a better match between the estimated
quantile and the observed value at level \code{tau}.
}
\details{
The score minimises to zero when the observation equals the estimated
quantile, so that smaller scores indicate a better fitting model.
Positive residuals are penalised by a factor of \code{tau}, and negative
residuals by \code{tau - 1}. This loss is also known as the stick function, check
loss, asymmetric absolute deviation, or pinball loss.

For observation \code{x}, estimate \code{x_hat}, and level \code{tau}, the score
(c.f. Gneiting, 2011) is

\deqn{
S_\tau(x, \hat{x}) =
\begin{cases}
  \tau |x - \hat{x})|, & x \ge \hat{x}, \\
  (1 - \tau)|x - \hat{x}|, & x < \hat{x}.
\end{cases}
}

Vector recycling of all three arguments follows the rules in
\code{vctrs::vec_recycle_common()}.
}
\examples{
quantile_score(c(5, 15, 10), xhat = 7, tau = 0.8)
quantile_score(c(5, 15, 10), xhat = c(6, 19, 12), tau = c(0.2, 0.9, 0.5))
}
\references{
Gneiting, T. (2011). Making and evaluating point forecasts. \emph{Journal of the
American Statistical Association}, 106(494), 746–762.
}
