% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{ft_collapse_lev}
\alias{ft_collapse_lev}
\title{Collapse Factor Levels Based on Grouping}
\usage{
ft_collapse_lev(factor_vec, groups)
}
\arguments{
\item{factor_vec}{A factor vector to modify.}

\item{groups}{A named list where each element contains levels to be collapsed into a new level named after the list element's name.}
}
\value{
A factor vector with collapsed levels.
}
\description{
Collapses specified levels of a factor into new levels based on a grouping list.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'cherry', 'date', 'elderberry'))

# Define groups
groups <- list(
  'Group1' = c('apple', 'banana'),
  'Group2' = c('cherry', 'date')
)

# Collapse levels
ft_collapse_lev(factor_vec, groups)
}
\author{
Kai Guo
}
