% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fregre.lm.r
\name{fregre.lm}
\alias{fregre.lm}
\title{Fitting Functional Linear Models}
\usage{
fregre.lm(
  formula,
  data,
  basis.x = NULL,
  basis.b = NULL,
  lambda = NULL,
  P = NULL,
  weights = rep(1, n),
  ...
)
}
\arguments{
\item{formula}{an object of class \code{formula} (or one that can be coerced
to that class): a symbolic description of the model to be fitted. The
details of model specification are given under \code{Details}.}

\item{data}{List that containing the variables in the model. 
Functional covariates are recommended to be of class fdata. 
Objects of class "fd" can be used at the user's own risk.}

\item{basis.x}{List of basis for functional explanatory data estimation.}

\item{basis.b}{List of basis for functional beta parameter estimation.}

\item{lambda}{List, indexed by the names of the functional covariates, 
which contains the Roughness penalty parameter.}

\item{P}{List, indexed by the names of the functional covariates, which contains the parameters for the creation of the penalty matrix.}

\item{weights}{weights}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Return \code{lm} object plus:
\itemize{
\item \code{sr2}: Residual variance.
\item \code{Vp}: Estimated covariance matrix for the parameters. 
\item \code{lambda}: A roughness penalty. 
\item \code{basis.x}: Basis used for \code{fdata} or \code{fd} covariates. 
\item \code{basis.b}: Basis used for beta parameter estimation.
\item \code{beta.l}: List of estimated beta parameter of functional covariates.
\item \code{data}: List containing the variables in the model.
\item \code{formula}: Formula used in the model.
}
}
\description{
Computes functional regression between functional (and non functional)
explanatory variables and scalar response using basis representation.
}
\details{
This section is presented as an extension of the linear regression models:
\code{\link{fregre.pc}}, \code{\link{fregre.pls}} and
\code{\link{fregre.basis}}. Now, the scalar response \eqn{Y} is estimated by
more than one functional covariate \eqn{X^j(t)} and also more than one non
functional covariate \eqn{Z^j}. The regression model is given by:
\deqn{E[Y|X,Z]=\alpha+\sum_{j=1}^{p}\beta_{j}Z^{j}+\sum_{k=1}^{q}\frac{1}{\sqrt{T_k}}\int_{T_k}{X^{k}(t)\beta_{k}(t)dt}
}{E[Y|X,Z]=\alpha+\sum_j \beta_j Z^j + \sum_k <X^k,\beta_k>}

where \eqn{Z=\left[ Z^1,\cdots,Z^p \right]}{Z=[Z^1,...,Z^p]} are the non
functional covariates, \eqn{X(t)=\left[ X^{1}(t_1),\cdots,X^{q}(t_q)
\right]}{X(t)=[X^1(t),...,X^q(t)]} are the functional ones and
\eqn{\epsilon} are random errors with mean zero , finite variance
\eqn{\sigma^2} and \eqn{E[X(t)\epsilon]=0}{E[X(t)\epsilon]=0}.  

The first item in the \code{data} list is called \emph{"df"} and is a data
frame with the response and non functional explanatory variables, as
\code{\link{lm}}. Functional covariates of class \code{fdata} or \code{fd}
are introduced in the following items in the \code{data} list.\cr

\code{basis.x} is a list of basis for represent each functional covariate.
The basis object can be created by the function:
\code{\link{create.pc.basis}}, \link[fda]{pca.fd}
\code{\link{create.pc.basis}}, \code{\link{create.fdata.basis}} or
\link[fda]{create.basis}.\cr \code{basis.b} is a list of basis for
represent each functional \eqn{\beta_k} parameter. If \code{basis.x} is a
list of functional principal components basis (see
\code{\link{create.pc.basis}} or \link[fda]{pca.fd}) the argument
\code{basis.b} \emph{(is unnecessary and)} is ignored.\cr

Penalty options are under development, not guaranteed to work properly.
The user can penalty the basis elements by: (i) \code{lambda} is a list of
rough penalty values of each functional covariate, see
 \code{\link{P.penalty}} for more details.
}
\examples{
\dontrun{
data(tecator)
x <- tecator$absorp.fdata
y <- tecator$y$Fat
tt <- x[["argvals"]]
dataf <- as.data.frame(tecator$y)

nbasis.x <- 11
nbasis.b <- 5
basis1 <- create.bspline.basis(rangeval=range(tt),nbasis=nbasis.x)
basis2 <- create.bspline.basis(rangeval=range(tt),nbasis=nbasis.b)
basis.x <- list("x"=basis1)
basis.b <- list("x"=basis2)
f <- Fat ~ Protein + x
ldat <- ldata("df"=dataf,"x"=x)
res <- fregre.lm(f,ldat,  basis.b=basis.b)
summary(res)
f2 <- Fat ~ Protein + xd +xd2
xd <- fdata.deriv(x,nderiv=1,class.out='fdata', nbasis=nbasis.x)
xd2 <- fdata.deriv(x,nderiv=2,class.out='fdata', nbasis=nbasis.x)
ldat2 <- list("df"=dataf,"xd"=xd,"x"=x,"xd2"=xd2)
basis.x2 <- NULL#list("xd"=basis1)
basis.b2 <- NULL#list("xd"=basis2)
basis.b2 <- list("xd"=basis2,"xd2"=basis2,"x"=basis2)
res2 <- fregre.lm(f2, ldat2,basis.b=basis.b2)
summary(res2)
par(mfrow=c(2,1))
plot(res$beta.l$x,main="functional beta estimation")
plot(res2$beta.l$xd,col=2)
}
}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), \emph{
Functional Data Analysis}, 2nd ed., Springer, New York.

Febrero-Bande, M., Oviedo de la Fuente, M. (2012).  \emph{Statistical
Computing in Functional Data Analysis: The R Package fda.usc.} Journal of
Statistical Software, 51(4), 1-28. \url{https://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as: \code{\link{predict.fregre.lm}} and
\code{\link{summary.lm}}.\cr Alternative method: \code{\link{fregre.glm}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{regression}
