% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{plotavsp}
\alias{plotavsp}
\title{Plot actual vs. predictions}
\usage{
plotavsp(predictions, gt)
}
\arguments{
\item{predictions}{The predictions of a classification model (\code{vector}).}

\item{gt}{The ground truth of the dataset (\code{vector}).}
}
\description{
Plot actual vs. predictions of a regression model.
}
\examples{
require (datasets)
data (trees)
model = LINREG (trees [, -3], trees [, 3])
pred = predict (model, trees [, -3])
plotavsp (pred, trees [, 3])
}
\seealso{
\code{\link{confusion}}, \code{\link{evaluation.accuracy}}, \code{\link{evaluation.fmeasure}}, \code{\link{evaluation.fowlkesmallows}}, \code{\link{evaluation.goodness}}, \code{\link{evaluation.jaccard}}, \code{\link{evaluation.kappa}},
\code{\link{evaluation.precision}}, \code{\link{evaluation.recall}},
\code{\link{evaluation.msep}}, \code{\link{evaluation.r2}}, \code{\link{performance}}
}
