% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featForge_sample_data.R
\docType{data}
\name{featForge_transactions}
\alias{featForge_transactions}
\title{Transactions Data for Package Testing and Demonstration}
\format{
A data frame with over 200 rows and 5 variables.
}
\usage{
data(featForge_transactions)
}
\description{
A dataset containing auto-generated banking transactions for package testing and demonstration purposes.
This example dataset consists of over 200 rows and 5 variables that illustrate the structure of a typical
transaction record associated with an application.
}
\details{
The dataset includes the following variables:

\describe{
  \item{application_id}{A numeric identifier linking the transaction to the corresponding application.}
  \item{scrape_date}{The end date of the transactions observation window. Assumed to be on the same date with the application's creation date.}
  \item{obs_start}{The start date of the transactions observation window. Assumed to be 180 days apart with the scrape_date.}
  \item{transaction_date}{The date and time when the transaction occurred. The date is always on or before the associated scrape_date (application's creation date) and on or after the obs_start date.}
  \item{amount}{The monetary amount of the transaction. Negative values indicate outgoing transactions, while positive values indicate incoming transactions.}
  \item{description}{A detailed description of the transaction. Descriptions vary in style and content, including combinations of generated institution names, random numbers, special characters, creative phrases, and full English sentences. For transactions with a category of "gambling", the description always includes the word "casino".}
  \item{category}{The transaction category, such as groceries, salary, gambling, utilities, travel, entertainment, rent, or shopping.}
}


This dataset was automatically generated for the purpose of testing and demonstrating the package functionality.
The transactions simulate realistic banking activity linked to application records. The transaction dates are
generated in relation to each application's creation date, ensuring logical consistency in the timeline, while the
descriptions have been enriched to include a wide variety of content, with special attention given to transactions
in the gambling category.
}
\examples{
# Load the transactions dataset
data(featForge_transactions)

# Display the first few rows of the dataset
head(featForge_transactions)
}
\keyword{datasets}
