% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fermicatsR.R
\docType{data}
\name{FHL1}
\alias{FHL1}
\title{1FHL Catalog (First Fermi-LAT Catalog of Sources Above 10 GeV)}
\format{A data frame with 39 variables on 514 sources.}
\source{
\url{http://fermi.gsfc.nasa.gov/ssc/data/access/lat/1FHL/}
}
\usage{
FHL1
}
\description{
The First Fermi-LAT Catalog of Sources Above 10 GeV (1FHL).
Ackermann, M. et al., The Astrophysical Journal Supplement Series, 209, 34 (2013).
FITS Filename: gll_psch_v07.fit, released 29 July 2013.
}
\section{Fields}{
 
\describe{
\item{Source_Name}{1FHL JHHMM.m+DDMM, constructed according to IAU Specifications for Nomenclature; 
m is decimal minutes of R.A.; in the name R.A. and decl. are truncated at 0.1 decimal minutes and 1' , respectively}
\item{RAJ2000}{Right Ascension, J2000}
\item{DEJ2000}{Declination, J2000} 
\item{GLON}{Galactic longitude, deg.} 
\item{GLAT}{Galactic latitude, deg.} 
\item{Conf_95_SemiMajor}{Long radius of error ellipse at 95\% confidence level} 
\item{Conf_95_SemiMinor}{Short radius of error ellipse at 95\% confidence level} 
\item{Conf_95_PosAng}{Position angle of the 95\% long axis from celestial north, positive toward increasing RA (eastward)}
\item{Signif_Avg}{Source significance in sigma units (derived from TS)}
\item{Pivot_Energy}{Energy at which error on differential flux is minimal, in GeV} 
\item{Flux_Density}{Differential flux at Pivot_Energy, cm^{-2} GeV^{-1} s^{-1}} 
\item{Unc_Flux_Density}{1 sigma error on differential flux at Pivot_Energy, cm^{-2} GeV^{-1} s^{-1}} 
\item{Spectral_Index}{Best fit photon number power-law index} 
\item{Unc_Spectral_Index}{1 sigma error on Spectral_Index} 
\item{Flux}{Integral photon flux from 10 to 500 GeV, cm^{-2} s^{-1}} 
\item{Unc_Flux}{1 sigma error on integral photon flux from 10 to 500 GeV, cm^{-2} s^{-1}} 
\item{Energy_Flux}{Energy flux from 10 to 500 GeV obtained by spectral fitting, erg cm^{-2} s^{-1}} 
\item{Unc_Energy_Flux}{1 sigma error on energy flux from 10 to 500 GeV, erg cm^{-2} s^{-1}} 
\item{Flux10_30GeV}{Integral flux from 10 to 30 GeV, cm^{-2} s^{-1}}
\item{Unc_Flux10_30GeV.1}{(lower) 1 sigma error on integral flux from 10 to 30 GeV, cm^{-2} s^{-1}, set to NaN if 1 sigma interval contains 0} 
\item{Unc_Flux10_30GeV.2}{(upper) 1 sigma error on integral flux from 10 to 30 GeV, cm^{-2} s^{-1}} 
\item{Sqrt_TS10_30GeV}{Square root of Test Statistic between 10 and 30 GeV}
\item{Flux30_100GeV}{Integral flux from 30 to 100 GeV, cm^{-2} s^{-1}} 
\item{Unc_Flux30_100GeV.1}{(lower) 1 sigma error on integral flux from 30 to 100 GeV, cm^{-2} s^{-1}, set to NaN if 1 sigma interval contains 0} 
\item{Unc_Flux30_100GeV.2}{(upper) 1 sigma error on integral flux from 30 to 100 GeV, cm^{-2} s^{-1}} 
\item{Sqrt_TS30_100GeV}{Square root of Test Statistic between 30 and 100 GeV} 
\item{Flux100_500GeV}{Integral flux from 100 to 500 GeV, cm^{-2} s^{-1}} 
\item{Unc_Flux100_500GeV.1}{(lower) 1 sigma error on integral flux from 100 to 500 GeV, cm^{-2} s^{-1}, set to NaN if 1 sigma interval contains 0} 
\item{Unc_Flux100_500GeV.2}{(upper) 1 sigma error on integral flux from 100 to 500 GeV, cm^{-2} s^{-1}} 
\item{Sqrt_TS100_500GeV}{Square root of Test Statistic between 100 and 500 GeV} 
\item{Variability_BayesBlocks}{Number of Bayesian Blocks found (1 for non-variable)} 
\item{Extended_Source_Name}{Cross-reference to the Extended Sources extension for extended sources, if any} 
\item{ASSOC_GAM}{Name of corresponding source in gamma-ray catalog, if any} 
\item{TEVCAT_FLAG}{P if positional association with non-extended source in TeVCat, E if associated with an extended source in TeVCat, 
N if no TeV association} 
\item{ASSOC_TEV}{Name of TeV association, if any}
\item{CLASS1}{Class designation for most likely association. Capital letters indicate firm identifications; 
lower-case letters indicate associations: Blazar of the BL Lac type (BZB), Blazar of the FSRQ type (BZQ), 
Active galaxy of uncertain type (AGU), Pulsar, identified by pulsations above 10 GeV (HPSR), 
Pulsar, identified by pulsations in LAT, excluding HPSR (PSR), Pulsar, no pulsations seen in LAT yet (psr), 
Supernova remnant (SNR), Pulsar wind nebula (PWN), Unclear whether SNR or PWN (spp), Radio galaxy (RDG), 
High-mass binary (HMB), Normal galaxy (GAL), Star forming region (SFR), LBV star (lbv), Unassociated source (  ).} 
\item{CLASS2}{Class designation for alternate association, if any} 
\item{ASSOC1}{Name of identified or most likely associated source} 
\item{ASSOC2}{Name of alternate association, if any}
}
}
\keyword{datasets}

