% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_starterpositions.R,
%   R/flea_starterpositions.R, R/mfl_starterpositions.R,
%   R/sleeper_starterpositions.R, R/template_starterpositions.R
\name{ff_starter_positions}
\alias{ff_starter_positions}
\alias{ff_starter_positions.espn_conn}
\alias{ff_starter_positions.flea_conn}
\alias{ff_starter_positions.mfl_conn}
\alias{ff_starter_positions.sleeper_conn}
\alias{ff_starter_positions.template_conn}
\title{Get Starting Lineup Settings}
\usage{
ff_starter_positions(conn, ...)

\method{ff_starter_positions}{espn_conn}(conn, ...)

\method{ff_starter_positions}{flea_conn}(conn, ...)

\method{ff_starter_positions}{mfl_conn}(conn, ...)

\method{ff_starter_positions}{sleeper_conn}(conn, ...)

\method{ff_starter_positions}{template_conn}(conn, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{other arguments (currently unused)}
}
\value{
A tidy dataframe of positional lineup rules, one row per position with minimum and maximum starters as well as total starter calculations.
}
\description{
This function returns a tidy dataframe with positional lineup rules.
}
\section{Methods (by class)}{
\itemize{
\item \code{ff_starter_positions(espn_conn)}: ESPN: returns min/max starters for each main player position

\item \code{ff_starter_positions(flea_conn)}: Fleaflicker: returns minimum and maximum starters for each player position.

\item \code{ff_starter_positions(mfl_conn)}: MFL: returns minimum and maximum starters for each player position.

\item \code{ff_starter_positions(sleeper_conn)}: Sleeper: returns minimum and maximum starters for each player position.

\item \code{ff_starter_positions(template_conn)}: Template: returns minimum and maximum starters for each player position.

}}
\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- espn_connect(season = 2020, league_id = 1178049)
  ff_starter_positions(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- fleaflicker_connect(season = 2020, league_id = 206154)
  ff_starter_positions(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  dlfidp_conn <- mfl_connect(2020, league_id = 33158)
  ff_starter_positions(conn = dlfidp_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  jml_conn <- sleeper_connect(league_id = "652718526494253056", season = 2021)
  ff_starter_positions(jml_conn)
}) # end try
}

\donttest{
template_conn <- ff_template(roster_type = "idp")
ff_starter_positions(template_conn)
}

}
