% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_connect.R
\name{ff_template}
\alias{ff_template}
\title{Default \code{conn} objects}
\usage{
ff_template(
  scoring_type = c("ppr", "half_ppr", "zero_ppr", "sfb11"),
  roster_type = c("1qb", "superflex", "sfb11", "idp")
)
}
\arguments{
\item{scoring_type}{One of c("default", "ppr", "half_ppr", "zero_ppr", "te_prem", "sfb11")}

\item{roster_type}{One of c("1qb", "superflex","sfb11", "idp")}
}
\value{
a connection object that can be used with \code{ff_scoring()}, \code{ff_scoringhistory()}, and \code{ff_starterpositions()}
}
\description{
This function creates a connection to a few league templates, and can be used instead of a real conn object in the following functions: \code{ff_scoring()}, \code{ff_scoringhistory()}, \code{ff_starterpositions()}.
}
\details{
Scoring types defined here are:
\itemize{
\item \code{ppr}: 6 pt passing/rushing/receiving touchdowns, 0.1 for rushing/receiving yards, 1 point per reception, -2 for fumbles/interceptions
\item \code{half_ppr}: same as \code{ppr} but with 0.5 points per reception
\item \code{zero_ppr}: same as \code{ppr} but with 0 points per reception
\item \code{te_prem}: same as \code{ppr} but TEs get 1.5 points per reception
\item \code{sfb11}: SFB11 scoring as defined by \url{https://scottfishbowl.com}
}

Roster settings defined here are:
\itemize{
\item \verb{1qb}:  Starts 1 QB, 2 RB, 3 WR, 1 TE, 2 FLEX
\item \code{superflex}: Starts 1 QB, 2 RB, 3 WR, 1 TE, 2 FLEX, 1 SUPERFLEX
\item \code{sfb11}: Starts 1 QB, 2 RB, 3 WR, 1 TE, 3 FLEX, 1 SUPERFLEX (flex positions can also start a kicker)
\item \code{idp}: Starts same as 1QB but also starts 3 DL, 3 LB, 3 DB, and two IDP FLEX
}
}
