% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{.correlation}
\alias{.correlation}
\title{Compute Normalized Correlation Between Two Signals}
\usage{
.correlation(a, b)
}
\arguments{
\item{a}{A \code{fftab} object or signal representing the first input.}

\item{b}{A \code{fftab} object or signal representing the second input.}
}
\value{
A numeric value representing the \strong{normalized correlation} between the two signals.
}
\description{
Computes the normalized correlation between two signals based on their Fourier representations.
}
\details{
This function computes the \strong{cross-spectrum} of two signals, removes the DC component,
and calculates the real part of the cross-spectrum sum. The result is normalized using the
variances of both signals.

Normalization ensures that the correlation value lies between -1 and 1.
}
\keyword{internal}
