% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byyr.R
\name{abundance_byyr}
\alias{abundance_byyr}
\alias{basal_area_byyr}
\title{Create tables of abundance and basal area by year.}
\usage{
abundance_byyr(vft, ...)

basal_area_byyr(vft, ...)
}
\arguments{
\item{vft}{A ForestGEO-like dataframe; particularly a ViewFullTable. As such,
it should contain columns \code{PlotName}, \code{CensusID}, \code{TreeID}, \code{StemID},
\code{Status}, \code{DBH}, \code{Genus}, \code{SpeciesName}, \code{ExactDate}, \code{PlotCensusNumber},
\code{Family}, \code{Tag}, and \code{HOM}. \code{ExactDate} should contain dates from
1980-01-01 to the present day in the format yyyy-mm-dd.}

\item{...}{Expressions to pick main stems of a specific \code{dbh} range (e.g.
\code{DBH >= 10} or \verb{DBH >= 10, DBH < 20}, or \code{DBH >= 10 & DBH < 20}).}
}
\value{
A dataframe.
}
\description{
\itemize{
\item \code{abundance_byyr()} first picks the main stem of each tree (see
?\code{\link[fgeo.tool:pick_main_stem]{fgeo.tool::pick_main_stem()}}). Then, for each species and each
round-mean-year of measurement, it counts the number of trees. The result
includes \strong{main stems} within a given dbh range.
\item \code{basal_area_byyr()} first sums the basal basal area of all stems of each
tree. Then, for each species and each round-mean-year of measurement,
it sums the basal area of all trees. The result includes all stems within a
given dbh range (notice the difference with \code{abundance_byyr()}).
}
}
\details{
You don't need to pick stems by status before feeding data to these
functions. Doing so may make your code more readable but it should not affect
the result. This is because the expressions passed to \code{...} pick data by
\code{dbh} and exclude the missing \code{dbh} values associated to non-alive stems,
including dead, missing, and gone stems.
}
\examples{
library(fgeo.tool)

# Example data
vft <- tibble(
  PlotName = c("luq", "luq", "luq", "luq", "luq", "luq", "luq", "luq"),
  CensusID = c(1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L),
  TreeID = c(1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L),
  StemID = c(1.1, 1.2, 2.1, 2.2, 1.1, 1.2, 2.1, 2.2),
  Status = c(
    "alive", "dead", "alive", "alive", "alive", "gone",
    "dead", "dead"
  ),
  DBH = c(10L, NA, 20L, 30L, 20L, NA, NA, NA),
  Genus = c("Gn", "Gn", "Gn", "Gn", "Gn", "Gn", "Gn", "Gn"),
  SpeciesName = c("spp", "spp", "spp", "spp", "spp", "spp", "spp", "spp"),
  ExactDate = c(
    "2001-01-01", "2001-01-01", "2001-01-01", "2001-01-01",
    "2002-01-01", "2002-01-01", "2002-01-01",
    "2002-01-01"
  ),
  PlotCensusNumber = c(1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L),
  Family = c("f", "f", "f", "f", "f", "f", "f", "f"),
  Tag = c(1L, 1L, 2L, 2L, 1L, 1L, 2L, 2L),
  HOM = c(130L, 130L, 130L, 130L, 130L, 130L, 130L, 130L)
)

vft

abundance_byyr(vft, DBH >= 10, DBH < 20)

abundance_byyr(vft, DBH >= 10)

basal <- basal_area_byyr(vft, DBH >= 10)
basal

# Skip R CMD check for speed
\donttest{
measurements_is_installed <- requireNamespace("measurements", quietly = TRUE)
if (measurements_is_installed) {
  # Convert units
  years <- c("yr_2001", "yr_2002")
  basal_he <- basal \%>\%
    purrr::modify_at(
      years,
      ~ measurements::conv_unit(.x, from = "mm2", to = "hectare")
    )
  basal_he

  # Standardize
  number_of_hectares <- 50
  basal_he \%>\%
    purrr::map_at(years, ~ .x / number_of_hectares)
}
}
}
\seealso{
\code{\link[fgeo.tool:pick_main_stem]{fgeo.tool::pick_main_stem()}}.

Other functions for abundance and basal area: 
\code{\link{abundance}()}
}
\concept{functions for abundance and basal area}
