% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_tag_status}
\alias{theme_tag_status}
\title{Theme for \code{plot_base_census()}.}
\usage{
theme_tag_status(
  panel.grid.major = element_line(colour = "black"),
  panel.grid.minor = element_line(colour = "black", linetype = "dotted"),
  panel.background = element_rect(fill = "white"),
  plot.title = element_text(size = 20),
  plot.subtitle = element_text(size = 12),
  plot.caption = element_text(size = 8),
  legend.position = "top",
  legend.title = element_blank(),
  axis.ticks = element_blank(),
  axis.text = element_text(size = 12),
  ...
)
}
\arguments{
\item{panel.background}{background of plotting area, drawn underneath plot
(\code{\link[ggplot2:element_rect]{element_rect()}}; inherits from \code{rect})}

\item{plot.title}{plot title (text appearance) (\code{\link[ggplot2:element_text]{element_text()}}; inherits
from \code{title}) left-aligned by default}

\item{plot.subtitle}{plot subtitle (text appearance) (\code{\link[ggplot2:element_text]{element_text()}};
inherits from \code{title}) left-aligned by default}

\item{plot.caption}{caption below the plot (text appearance)
(\code{\link[ggplot2:element_text]{element_text()}}; inherits from \code{title}) right-aligned by default}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{legend.title}{title of legend (\code{\link[ggplot2:element_text]{element_text()}}; inherits from
\code{title})}

\item{...}{additional element specifications not part of base ggplot2. In general,
these should also be defined in the \verb{element tree} argument.}
}
\description{
Theme for \code{plot_base_census()}.
}
\examples{
class(theme_tag_status())
}
\seealso{
Other functions to plot tag status: 
\code{\link{header_tag_status}()},
\code{\link{plot_tag_status_by_subquadrat}()}
}
\concept{functions to plot tag status}
\keyword{internal}
